/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExpressionVersionRestriction;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.filter.ConstraintSeparator;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.filter.FreezeBlockFinder;
import net.ssehub.easy.varModel.model.filter.FrozenElementsFinder;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ConfigurationSaver {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ConfigurationSaver.class, "net.ssehub.easy.varModel");
    private Configuration srcConfiguration;
    private Project destProject;
    private boolean onlyUserInput;

    ConfigurationSaver(Configuration srcConfiguration, boolean ownProject) throws ConfigurationException {
        this(srcConfiguration, ownProject, true);
    }

    protected ConfigurationSaver(Configuration srcConfiguration, boolean ownProject, boolean onlyUserInput) throws ConfigurationException {
        this.srcConfiguration = srcConfiguration;
        this.onlyUserInput = onlyUserInput;
        if (ownProject) {
            this.destProject = this.createProject(srcConfiguration);
            Version ver = srcConfiguration.getProject().getVersion();
            if (ver != null) {
                this.destProject.setVersion(ver);
            }
            this.addVersion(this.destProject, srcConfiguration);
            this.addImports(this.destProject, srcConfiguration);
            this.addAttributes(this.destProject, srcConfiguration);
            this.addLocalVariables(this.destProject, srcConfiguration);
        } else {
            this.destProject = srcConfiguration.getProject();
            this.removedLocalConfigChanges();
        }
        StringBuilder errors = new StringBuilder();
        int code = 0;
        Map<AbstractVariable, IDecisionVariable> decisions = srcConfiguration.getConfiguredDecisions();
        for (Map.Entry<AbstractVariable, IDecisionVariable> entry : decisions.entrySet()) {
            AbstractVariable varDecl = entry.getKey();
            IDecisionVariable var = entry.getValue();
            if (!this.isSavingEnabled(this.destProject, var)) continue;
            int c = this.processAssignment(this.destProject, errors, varDecl, var, var.getValue());
            if (code == 0) {
                code = c;
            }
            int a = 0;
            while (a < var.getAttributesCount()) {
                IDecisionVariable attrVar = var.getAttribute(a);
                Value value = attrVar.getValue();
                if (value != null && this.isSavingEnabled(this.destProject, attrVar)) {
                    c = this.processAssignment(this.destProject, errors, attrVar.getDeclaration(), attrVar, value);
                    if (code == 0) {
                        code = c;
                    }
                }
                ++a;
            }
        }
        this.saveFreezeStates(this.destProject);
        if (errors.length() > 0) {
            throw new ConfigurationException(srcConfiguration, errors.toString(), code);
        }
    }

    public Project getSavedConfiguration() {
        return this.destProject;
    }

    protected Configuration getConfiguration() {
        return this.srcConfiguration;
    }

    protected Project createProject(Configuration srcConfiguration) {
        return new Project(srcConfiguration.getProject().getName() + "_conf");
    }

    protected void addVersion(Project destProject, Configuration srcConfiguration) {
        Version ver = srcConfiguration.getProject().getVersion();
        if (ver != null) {
            destProject.setVersion(ver);
        }
    }

    protected void addImports(Project destProject, Configuration srcConfiguration) {
        Version ver = srcConfiguration.getProject().getVersion();
        ExpressionVersionRestriction restrictions = null;
        if (ver != null) {
            try {
                DecisionVariableDeclaration[] vars = ExpressionVersionRestriction.createRestrictionVars(srcConfiguration.getProject().getName());
                ConstraintSyntaxTree expr = ExpressionVersionRestriction.createSingleRestriction(vars[1], "==", ver);
                restrictions = new ExpressionVersionRestriction(expr, vars[0], vars[1]);
            }
            catch (RestrictionEvaluationException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)e);
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception((Exception)e);
            }
        }
        destProject.addImport(new ProjectImport(srcConfiguration.getProject().getName(), null, false, false, restrictions));
    }

    protected void addLocalVariables(Project destProject, Configuration srcConfiguration) {
    }

    protected void addAttributes(Project destProject, Configuration srcConfiguration) {
    }

    protected ConstraintSyntaxTree createAssignmentConstraint(Project dstProject, AbstractVariable decl, IDecisionVariable var, Value value) {
        return new OCLFeatureCall(this.deriveOperand(decl, var), "=", new ConstantValue(this.toSaveableValue(var, value)));
    }

    protected boolean isSavingEnabled(Project destProject, IDecisionVariable var) {
        return true;
    }

    private void removedLocalConfigChanges() {
        ConstraintSeparator separator = new ConstraintSeparator(this.destProject, false);
        ArrayList<ContainableModelElement> assignmentConstraints = new ArrayList<ContainableModelElement>();
        assignmentConstraints.addAll(separator.getAssingmentConstraints());
        this.destProject.removeElements(assignmentConstraints);
        FreezeBlockFinder finder = new FreezeBlockFinder(this.destProject, FilterType.NO_IMPORTS);
        ArrayList<ContainableModelElement> freezeBlocks = new ArrayList<ContainableModelElement>();
        freezeBlocks.addAll(finder.getFreezeBlocks());
        this.destProject.removeElements(freezeBlocks);
    }

    private int processAssignment(Project confProject, StringBuilder errors, AbstractVariable decl, IDecisionVariable var, Value value) {
        int code = 0;
        if (!(value == null || AssignmentState.UNDEFINED == var.getState() || AssignmentState.DEFAULT == var.getState() || this.onlyUserInput && AssignmentState.DERIVED == var.getState())) {
            ConstraintSyntaxTree call = this.createAssignmentConstraint(confProject, decl, var, value);
            try {
                confProject.add(new Constraint(call, (IModelElement)confProject));
            }
            catch (CSTSemanticException e) {
                if (errors.length() == 0) {
                    code = e.getCode();
                }
                if (errors.length() > 0) {
                    errors.append(", ");
                }
                errors.append(e.getMessage());
            }
        }
        return code;
    }

    protected ConstraintSyntaxTree deriveOperand(AbstractVariable decl, IDecisionVariable var) {
        ConstraintSyntaxTree operand = null;
        if (var.getParent() instanceof IDecisionVariable) {
            IDecisionVariable parent = (IDecisionVariable)var.getParent();
            AbstractVariable parentDecl = parent.getDeclaration();
            IDatatype parentType = parentDecl.getType();
            if (var.getDeclaration().isAttribute()) {
                Attribute attr = (Attribute)var.getDeclaration();
                if (attr.getElement() instanceof AbstractVariable) {
                    operand = new AttributeVariable(new Variable((AbstractVariable)((Object)attr.getElement())), attr);
                }
            } else if (Compound.TYPE.isAssignableFrom(parentType)) {
                operand = new CompoundAccess(this.deriveOperand(parentDecl, parent), decl.getName());
            }
        }
        if (operand == null) {
            operand = new Variable(decl);
        }
        return operand;
    }

    protected Value toSaveableValue(IDecisionVariable var, Value value) {
        if (value != null && value.getValue() != null && value instanceof CompoundValue) {
            CompoundValue cmpValue = (CompoundValue)value;
            ArrayList<Object> slotsNValues = new ArrayList<Object>();
            int i = 0;
            int n = var.getNestedElementsCount();
            while (i < n) {
                IDecisionVariable nestedVar = var.getNestedElement(i);
                IAssignmentState nestedState = nestedVar.getState();
                if (AssignmentState.UNDEFINED != nestedState && this.isSavingEnabled(this.srcConfiguration.getProject(), nestedVar) && this.checkState(nestedState)) {
                    String slotName = nestedVar.getDeclaration().getName();
                    slotsNValues.add(slotName);
                    slotsNValues.add(this.toSaveableValue(nestedVar, cmpValue.getNestedValue(slotName)));
                }
                ++i;
            }
            try {
                value = ValueFactory.createValue(var.getValue().getType(), slotsNValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                Bundle.getLogger(ConfigurationSaver.class).exception((Exception)e);
            }
        }
        return value;
    }

    private boolean checkState(IAssignmentState state) {
        return !this.onlyUserInput || AssignmentState.DERIVED != state && AssignmentState.DEFAULT != state;
    }

    protected void saveFreezeStates(Project confProject) {
        ArrayList<IFreezable> frozenElements = new ArrayList<IFreezable>();
        for (IDecisionVariable decisionVariable : this.srcConfiguration) {
            if (decisionVariable.getState() != AssignmentState.FROZEN || !(decisionVariable.getDeclaration() instanceof IFreezable)) continue;
            frozenElements.add((IFreezable)((Object)decisionVariable.getDeclaration()));
        }
        FrozenElementsFinder finder = new FrozenElementsFinder(this.destProject, FilterType.ONLY_IMPORTS);
        List<IFreezable> alreadyFrozenElements = finder.getFrozenElements();
        frozenElements.removeAll(alreadyFrozenElements);
        if (frozenElements.size() > 0) {
            IFreezable[] freezables = new IFreezable[frozenElements.size()];
            frozenElements.toArray(freezables);
            FreezeBlock freeze = this.createFreezeBlock(freezables, confProject);
            confProject.add(freeze);
        }
    }

    protected FreezeBlock createFreezeBlock(IFreezable[] freezables, Project parent) {
        return new FreezeBlock(freezables, null, null, parent);
    }
}

