/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.NestedVarConfigProvider;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class ContainerItemConfigProvider
extends NestedVarConfigProvider {
    private int index;
    private IAssignmentState state;

    ContainerItemConfigProvider(ContainerVariable parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected Value getValue() {
        Value value = null;
        ContainerValue parentValue = (ContainerValue)this.getParent().getValue();
        if (parentValue != null && parentValue.getElementSize() > this.index) {
            value = parentValue.getElement(this.index);
        }
        return value;
    }

    @Override
    protected void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        ContainerValue parentValue = (ContainerValue)this.getParent().getValue();
        if (parentValue != null) {
            try {
                parentValue.setValue(this.index, value);
            }
            catch (ValueDoesNotMatchTypeException e) {
                throw new ConfigurationException(this.getConfiguration(), e.getMessage(), 19004);
            }
        } else {
            ContainerVariable parent = this.getParent();
            String nestedName = parent.getElementName(this.index);
            IDatatype type = DerivedDatatype.resolveToBasis(parent.getDeclaration().getType());
            type = ((Container)type).getContainedType();
            DecisionVariableDeclaration nestedDecl = new DecisionVariableDeclaration(nestedName, type, parent.getDeclaration());
            VariableCreator creator = new VariableCreator(nestedDecl, parent, parent.isVisible(), false);
            IDecisionVariable nestedVar = creator.getVariable(false);
            parent.addNestedElement(nestedVar);
        }
        this.state = state;
    }

    @Override
    protected IAssignmentState getState() {
        return this.state;
    }

    @Override
    protected void setState(IAssignmentState state) {
        this.state = state;
    }

    @Override
    protected AbstractVariable getDeclaration() {
        return null;
    }

    @Override
    protected ContainerVariable getParent() {
        return (ContainerVariable)super.getParent();
    }

    void setIndex(int newIndex) {
        this.index = newIndex;
    }

    @Override
    protected void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.state = state;
    }

    @Override
    protected void freeze(IFreezeSelector selector) {
        IDecisionVariable thisVariable;
        if (this.index >= 0 && this.index < this.getParent().getNestedElementsCount() && selector.shallFreeze(thisVariable = this.getParent().getNestedElement(this.index))) {
            this.state = AssignmentState.FROZEN;
        }
    }
}

