/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class CompoundAccess
extends ConstraintSyntaxTree {
    private ConstraintSyntaxTree compoundExpression;
    private String slotName;
    private AbstractVariable slot;

    CompoundAccess() {
    }

    public CompoundAccess(ConstraintSyntaxTree compoundExpression, String slotName) {
        this.compoundExpression = compoundExpression;
        this.slotName = slotName;
    }

    private DecisionVariableDeclaration searchSlot(Compound comp, String slotName) {
        DecisionVariableDeclaration slot = comp.getElement(slotName);
        int r = 0;
        while (slot == null && r < comp.getRefinesCount()) {
            slot = this.searchSlot(comp.getRefines(r), slotName);
            ++r;
        }
        return slot;
    }

    public IDatatype getStaticType() throws CSTSemanticException {
        Value value;
        IDatatype result = null;
        IDatatype cExpression = this.compoundExpression.inferDatatype();
        if (cExpression.isAssignableFrom(MetaType.TYPE) && this.compoundExpression instanceof ConstantValue && (value = ((ConstantValue)this.compoundExpression).getConstantValue()) instanceof MetaTypeValue) {
            result = ((MetaTypeValue)value).getValue();
        }
        return result;
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        IDatatype result = null;
        if (this.slot == null) {
            Value value;
            IDatatype staticType = this.getStaticType();
            IDatatype cExpression = staticType != null ? staticType : this.compoundExpression.inferDatatype();
            if ((cExpression = TypeQueries.resolveFully(cExpression)).isAssignableFrom(MetaType.TYPE) && cExpression instanceof ConstantValue && (value = ((ConstantValue)((Object)cExpression)).getConstantValue()) instanceof MetaTypeValue) {
                cExpression = ((MetaTypeValue)value).getValue();
            }
            if (cExpression.isAssignableFrom(Compound.TYPE) && cExpression instanceof Compound) {
                Compound comp = (Compound)cExpression;
                this.slot = this.searchSlot(comp, this.slotName);
                if (this.slot == null) {
                    throw new CSTSemanticException("type '" + comp.getName() + "' does not have a slot named '" + this.slotName + "'", 10104);
                }
            } else {
                String ex = null;
                if (this.compoundExpression != null) {
                    ex = StringProvider.toIvmlString(this.compoundExpression);
                }
                throw new CSTSemanticException("expression '" + ex + "' in '" + ex + "." + this.slotName + "' does not evaluate to a compound", 10100);
            }
        }
        if (this.slot != null) {
            result = this.slot.getType();
        }
        return result;
    }

    public ConstraintSyntaxTree getCompoundExpression() {
        return this.compoundExpression;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public AbstractVariable getResolvedSlot() {
        return this.slot;
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitCompoundAccess(this);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof CompoundAccess) {
            CompoundAccess other = (CompoundAccess)obj;
            equals = this.slotName.equals(other.slotName);
            equals &= this.compoundExpression.equals(other.compoundExpression);
            equals = this.slot == null ? (equals &= other.slot == null) : (equals &= this.slot.equals(other.slot));
        }
        return equals;
    }

    public int hashCode() {
        int result = this.slotName.hashCode() + this.compoundExpression.hashCode();
        if (this.slot != null) {
            result += this.slot.hashCode();
        }
        return result;
    }
}

