/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ConstraintOperations {
    private ConstraintOperations() {
    }

    static EvaluationAccessor handleConstraintAssignment(EvaluationAccessor operand, ConstraintSyntaxTree cst) {
        ConstantAccessor result;
        try {
            operand.setValue(ValueFactory.createValue(ConstraintType.TYPE, cst), true);
            result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.TRUE, true, operand.getContext());
        }
        catch (ValueDoesNotMatchTypeException e) {
            operand.getContext().addErrorMessage(e);
            result = null;
        }
        return result;
    }

    static EvaluationAccessor handleConstraintEquals(EvaluationAccessor operand, ConstraintSyntaxTree cst, boolean negate) {
        Value oValue;
        EvaluationAccessor result;
        if (!operand.isAssigned() && operand.isAssignable()) {
            result = !negate ? ConstraintOperations.handleConstraintAssignment(operand, cst) : null;
        }
        if ((oValue = operand.getValue()) instanceof ConstraintValue) {
            boolean equals = ((ConstraintValue)oValue).getValue().equals(cst);
            if (negate) {
                equals = !equals;
            }
            result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(equals), true, operand.getContext());
        } else {
            result = null;
        }
        return result;
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, ConstraintType.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, ConstraintType.EQUALS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, ConstraintType.UNEQUALS, ConstraintType.UNEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, ConstraintType.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, ConstraintType.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IF_DEFINED, ConstraintType.IF_DEFINED);
    }
}

