/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.Value;

public abstract class EvaluationAccessor {
    private EvaluationContext context;
    private List<IDecisionVariable> nestedElements = new ArrayList<IDecisionVariable>();

    protected void bind(EvaluationContext context) {
        this.context = context;
    }

    public void clear() {
        this.context = null;
        this.nestedElements.clear();
    }

    public EvaluationContext getContext() {
        return this.context;
    }

    public abstract Value getValue();

    public Value getDereferencedValue() {
        return this.getContext().getDereferencedValue(this.getValue());
    }

    public abstract Value getReferenceValue();

    public abstract boolean setValue(Value var1, boolean var2);

    public EvaluationAccessor getValue(EvaluationAccessor accessor) {
        this.getContext().addErrorMessage("left side of accessor must be a compound value", 102);
        return null;
    }

    public void setValue(EvaluationAccessor accessor, Value value) {
        this.getContext().addErrorMessage("left side of accessor must be a compound value", 102);
    }

    public boolean isAssigned() {
        IDecisionVariable var = this.getVariable();
        boolean assigned = var != null ? AssignmentState.UNDEFINED != var.getState() : false;
        return assigned;
    }

    public abstract void release();

    public abstract IDecisionVariable getVariable();

    public static <T extends EvaluationAccessor> T release(T accessor) {
        if (accessor != null) {
            accessor.release();
        }
        return null;
    }

    public abstract boolean isAssignable();

    public void validateContext(EvaluationContext context) {
        if (this.context == null) {
            this.context = context;
        }
    }

    protected IDecisionVariable dereferenceIfNeeded(IDecisionVariable variable, Value value) {
        IDecisionVariable v = variable;
        if (TypeQueries.isReference(variable.getDeclaration().getType()) && !TypeQueries.isReference(value.getType()) && (v = Configuration.dereference(v)) == null) {
            v = variable;
        }
        return v;
    }

    public void bindContainer(IDecisionVariable container) {
        if (container != null) {
            int e = 0;
            int n = container.getNestedElementsCount();
            while (e < n) {
                this.nestedElements.add(container.getNestedElement(e));
                ++e;
            }
        }
    }

    public void addBoundContainerElement(EvaluationAccessor accessor, int index) {
        IDecisionVariable var;
        IDecisionVariable element = accessor.getBoundContainerElement(index);
        if (element == null && (var = accessor.getVariable()) != null && index >= 0 && index <= var.getNestedElementsCount()) {
            element = var.getNestedElement(index);
        }
        this.addBoundContainerElement(element);
    }

    public void clearContainerElements() {
        this.nestedElements.clear();
    }

    public void addBoundContainerElement(IDecisionVariable element) {
        this.nestedElements.add(element);
    }

    public void bindContainer(EvaluationAccessor accessor) {
        this.nestedElements.clear();
        this.nestedElements.addAll(accessor.nestedElements);
    }

    public IDecisionVariable getBoundContainerElement(int index) {
        return index >= 0 && index < this.nestedElements.size() ? this.nestedElements.get(index) : null;
    }

    public int getBoundContainerElementCount() {
        return this.nestedElements.size();
    }

    public boolean isConstant() {
        return false;
    }
}

