/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.cstEvaluation.BooleanOperations;
import net.ssehub.easy.varModel.cstEvaluation.CompoundOperations;
import net.ssehub.easy.varModel.cstEvaluation.ConstraintOperations;
import net.ssehub.easy.varModel.cstEvaluation.ContainerOperations;
import net.ssehub.easy.varModel.cstEvaluation.EnumOperations;
import net.ssehub.easy.varModel.cstEvaluation.FreezeVarOperations;
import net.ssehub.easy.varModel.cstEvaluation.GenericNumberOperations;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IIteratorEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IntegerOperations;
import net.ssehub.easy.varModel.cstEvaluation.MetaTypeOperations;
import net.ssehub.easy.varModel.cstEvaluation.RealOperations;
import net.ssehub.easy.varModel.cstEvaluation.ReferenceOperations;
import net.ssehub.easy.varModel.cstEvaluation.SequenceOperations;
import net.ssehub.easy.varModel.cstEvaluation.SetOperations;
import net.ssehub.easy.varModel.cstEvaluation.StringOperations;
import net.ssehub.easy.varModel.cstEvaluation.VersionOperations;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class EvaluatorRegistry {
    private static final Map<Operation, IOperationEvaluator> OP_EVALUATORS = new HashMap<Operation, IOperationEvaluator>();
    private static final Map<Operation, IIteratorEvaluator> ITER_EVALUATORS = new HashMap<Operation, IIteratorEvaluator>();

    static {
        GenericOperations.register();
        MetaTypeOperations.register();
        BooleanOperations.register();
        RealOperations.register();
        IntegerOperations.register();
        StringOperations.register();
        GenericNumberOperations.register();
        ReferenceOperations.register();
        ConstraintOperations.register();
        EnumOperations.register();
        CompoundOperations.register();
        ContainerOperations.register();
        SetOperations.register();
        SequenceOperations.register();
        VersionOperations.register();
        FreezeVarOperations.register();
    }

    public static void registerEvaluator(IOperationEvaluator evaluator, Operation ... operations) {
        if (evaluator != null) {
            int o = 0;
            while (o < operations.length) {
                OP_EVALUATORS.put(operations[o], evaluator);
                ++o;
            }
        }
    }

    public static void registerEvaluator(IIteratorEvaluator evaluator, Operation ... operations) {
        if (evaluator != null) {
            int o = 0;
            while (o < operations.length) {
                ITER_EVALUATORS.put(operations[o], evaluator);
                ++o;
            }
        }
    }

    public static IOperationEvaluator getOperationEvaluator(Operation operation) {
        return OP_EVALUATORS.get(operation);
    }

    public static IIteratorEvaluator getIteratorEvaluator(Operation operation) {
        return ITER_EVALUATORS.get(operation);
    }
}

