/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashSet;
import java.util.List;
import net.ssehub.easy.varModel.cstEvaluation.ContainerOperations;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;

public class SetOperations {
    static final IOperationEvaluator UNION = new ContainerOperations.Container2OperationEvaluator(new ContainerOperations.Container2Operation(){

        @Override
        public void evaluate(ContainerOperations.ContainerArgument c1, ContainerOperations.ContainerArgument c2, List<Value> result, EvaluationAccessor resAcc) {
            HashSet<Value> done = new HashSet<Value>();
            SetOperations.addAll(c1, result, done, resAcc);
            SetOperations.addAll(c2, result, done, resAcc);
        }
    });
    static final IOperationEvaluator DIFFERENCE = new ContainerOperations.Container2OperationEvaluator(new ContainerOperations.Container2Operation(){

        @Override
        public void evaluate(ContainerOperations.ContainerArgument c1, ContainerOperations.ContainerArgument c2, List<Value> result, EvaluationAccessor resAcc) {
            HashSet<Value> inC2 = new HashSet<Value>();
            ContainerOperations.addAll(c2, inC2, resAcc);
            ContainerValue cont1 = c1.getValue();
            EvaluationAccessor contAcc1 = c1.getAccessor();
            int e = 0;
            while (e < cont1.getElementSize()) {
                Value val = cont1.getElement(e);
                if (!inC2.contains(val)) {
                    result.add(val);
                    resAcc.addBoundContainerElement(contAcc1, e);
                }
                ++e;
            }
        }
    });
    static final IOperationEvaluator SYMMETRIC_DIFFERENCE = new ContainerOperations.Container2OperationEvaluator(new ContainerOperations.Container2Operation(){

        @Override
        public void evaluate(ContainerOperations.ContainerArgument c1, ContainerOperations.ContainerArgument c2, List<Value> result, EvaluationAccessor resAcc) {
            HashSet<Value> inC1 = new HashSet<Value>();
            HashSet<Value> inC2 = new HashSet<Value>();
            ContainerOperations.addAll(c1, inC1, resAcc);
            ContainerOperations.addAll(c2, inC2, resAcc);
            SetOperations.addAllXor(c1, inC1, inC2, result, resAcc);
            SetOperations.addAllXor(c2, inC1, inC2, result, resAcc);
        }
    });
    static final IOperationEvaluator EXCLUDING = new ContainerOperations.ContainerValueOperationEvaluator(new ContainerOperations.ContainerValueOperation(){

        @Override
        public void evaluate(ContainerOperations.ContainerArgument cnt, Value value, List<Value> result, EvaluationAccessor resAcc) {
            ContainerValue cont = cnt.getValue();
            EvaluationAccessor contAcc = cnt.getAccessor();
            int i = 0;
            while (i < cont.getElementSize()) {
                Value elt = cont.getElement(i);
                if (!elt.equals(value)) {
                    result.add(elt);
                    resAcc.addBoundContainerElement(contAcc, i);
                }
                ++i;
            }
        }
    });
    static final IOperationEvaluator INCLUDING = new ContainerOperations.ContainerValueOperationEvaluator(new ContainerOperations.ContainerValueOperation(){

        @Override
        public void evaluate(ContainerOperations.ContainerArgument cnt, Value value, List<Value> result, EvaluationAccessor resAcc) {
            boolean found = false;
            ContainerValue cont = cnt.getValue();
            EvaluationAccessor contAcc = cnt.getAccessor();
            int i = 0;
            while (i < cont.getElementSize()) {
                Value elt = cont.getElement(i);
                result.add(elt);
                resAcc.addBoundContainerElement(contAcc, i);
                found = elt.equals(value);
                ++i;
            }
            if (!found) {
                result.add(value);
                resAcc.addBoundContainerElement(null);
            }
        }
    });

    private SetOperations() {
    }

    public static void register() {
        EvaluatorRegistry.registerEvaluator(ContainerOperations.AS_SET, Set.AS_SET, Set.TO_SET);
        EvaluatorRegistry.registerEvaluator(ContainerOperations.AS_SEQUENCE, Set.AS_SEQUENCE, Set.TO_SEQUENCE);
        EvaluatorRegistry.registerEvaluator(UNION, Set.UNION);
        EvaluatorRegistry.registerEvaluator(ContainerOperations.INTERSECT, Set.INTERSECTION);
        EvaluatorRegistry.registerEvaluator(EXCLUDING, Set.EXCLUDING);
        EvaluatorRegistry.registerEvaluator(INCLUDING, Set.INCLUDING);
        EvaluatorRegistry.registerEvaluator(DIFFERENCE, Set.DIFFERENCE);
        EvaluatorRegistry.registerEvaluator(SYMMETRIC_DIFFERENCE, Set.SYMMETRIC_DIFFERENCE);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, Set.EQUALS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, Set.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(ContainerOperations.ADD, Set.ADD);
        EvaluatorRegistry.registerEvaluator(new ContainerOperations.FlattenOperationEvaluator(false), Set.FLATTEN);
    }

    private static final void addAll(ContainerOperations.ContainerArgument cnt, List<Value> result, HashSet<Value> done, EvaluationAccessor resAcc) {
        ContainerValue cont = cnt.getValue();
        EvaluationAccessor contAcc = cnt.getAccessor();
        int i = 0;
        while (i < cont.getElementSize()) {
            Value elt = cont.getElement(i);
            if (!done.contains(elt)) {
                result.add(elt);
                resAcc.addBoundContainerElement(contAcc, i);
                done.add(elt);
            }
            ++i;
        }
    }

    private static void addAllXor(ContainerOperations.ContainerArgument cnt, HashSet<Value> set1, HashSet<Value> set2, List<Value> result, EvaluationAccessor resAcc) {
        ContainerValue cont = cnt.getValue();
        EvaluationAccessor contAcc = cnt.getAccessor();
        int e = 0;
        while (e < cont.getElementSize()) {
            Value val = cont.getElement(e);
            if (set1.contains(val) ^ set2.contains(val)) {
                result.add(val);
                resAcc.addBoundContainerElement(contAcc, e);
            }
            ++e;
        }
    }
}

