/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlException;

public abstract class AnnotationVisitor {
    protected abstract void processAttributeAssignment(AttributeAssignment var1) throws IvmlException;

    protected abstract void processAttribute(Attribute var1) throws IvmlException;

    protected void addToScope(Set<Object> scope, IModelElement element, IAttributeAccess access) {
        scope.add(element);
    }

    public void visitAnnotations(IAttributeAccess access) throws IvmlException {
        if (!(access instanceof Attribute)) {
            HashSet<Object> scope = new HashSet<Object>();
            scope.add(access);
            IModelElement parent = access.getParent();
            while (parent != null) {
                this.addToScope(scope, parent, access);
                if (parent instanceof AttributeAssignment) {
                    this.processAttributeAssignment((AttributeAssignment)parent);
                }
                parent = parent.getParent();
            }
            this.visitAnnotations(access, scope);
            parent = access.getParent();
            while (parent != null) {
                if (parent instanceof IAttributeAccess) {
                    this.visitAnnotations((IAttributeAccess)((Object)parent), scope);
                }
                parent = parent.getParent();
            }
        }
    }

    private void visitAnnotations(IAttributeAccess access, Set<Object> scope) throws IvmlException {
        int a = 0;
        while (a < access.getAttributesCount()) {
            Attribute attr = access.getAttribute(a);
            IAttributableElement elt = attr.getElement();
            if (elt == null || scope.contains(elt)) {
                this.processAttribute(access.getAttribute(a));
            }
            ++a;
        }
    }
}

