/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class CompoundAccessStatement
extends ContainableModelElement
implements IFreezable {
    private AbstractVariable compoundVariable;
    private String slotName;

    public CompoundAccessStatement(AbstractVariable compoundVariable, String slotName, IModelElement parent) {
        super("", parent);
        this.compoundVariable = compoundVariable;
        this.slotName = slotName;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public AbstractVariable getCompoundVariable() {
        return this.compoundVariable;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitCompoundAccessStatement(this);
    }

    @Override
    public IDatatype getType() {
        IDatatype result = AnyType.TYPE;
        AbstractVariable slotVar = this.getSlotDeclaration();
        if (slotVar != null) {
            result = slotVar.getType();
        }
        return result;
    }

    public AbstractVariable getSlotDeclaration() {
        DecisionVariableDeclaration result = null;
        if (this.compoundVariable.getType() instanceof Compound) {
            Compound type = (Compound)this.compoundVariable.getType();
            result = type.getElement(this.slotName);
        }
        return result;
    }

    @Override
    public int getAttributesCount() {
        AbstractVariable var = this.getSlotDeclaration();
        return var == null ? 0 : var.getAttributesCount();
    }

    @Override
    public Attribute getAttribute(String name) {
        AbstractVariable var = this.getSlotDeclaration();
        return var == null ? null : var.getAttribute(name);
    }

    @Override
    public Attribute getAttribute(int index) {
        AbstractVariable var = this.getSlotDeclaration();
        return var == null ? null : var.getAttribute(index);
    }
}

