/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitable;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;

public abstract class ContainableModelElement
extends ModelElement
implements IDatatypeVisitable {
    private IModelElement parent;
    private transient String namespace;

    protected ContainableModelElement(String name, IModelElement parent) {
        super(name);
        this.parent = parent;
    }

    @Override
    public final IModelElement getParent() {
        return this.parent;
    }

    public final IModelElement getTopLevelParent() {
        IModelElement parent = this.getParent();
        if (parent != null && !(parent instanceof Project)) {
            ContainableModelElement immidiateParent = (ContainableModelElement)parent;
            parent = immidiateParent.getTopLevelParent();
        }
        return parent;
    }

    public final Project getProject() {
        IModelElement parent = this.getParent();
        while (parent != null && !(parent instanceof Project)) {
            parent = parent.getParent();
        }
        return parent instanceof Project ? (Project)parent : null;
    }

    public final boolean isTopLevel() {
        boolean top = false;
        if (this.parent instanceof Project) {
            top = true;
        }
        return top;
    }

    @Override
    public String getNameSpace() {
        String result;
        if (this.namespace == null) {
            if (this.parent == null) {
                result = "";
            } else {
                IModelElement p = this.parent;
                while (p != null && p.isTransparent()) {
                    p = p.getParent();
                }
                result = p == null ? "" : (p instanceof DecisionVariableDeclaration ? p.getNameSpace() : p.getQualifiedName());
            }
            this.namespace = result;
        } else {
            result = this.namespace;
        }
        return result;
    }

    @Override
    public String getQualifiedName() {
        Object result = this.getNameSpace();
        result = ((String)result).length() > 0 ? (String)result + "::" + this.getName() : this.getName();
        return result;
    }

    public final void setParent(IModelElement parent) {
        this.parent = parent;
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
    }
}

