/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cstEvaluation.LocalConfiguration;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IConstraintHolder;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.ProjectDecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.ProjectType;
import net.ssehub.easy.varModel.model.StructuredComment;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

public class Project
extends ModelElement
implements IModel,
IAttributableElement,
IResolutionScope,
ICustomOperationAccessor,
IFreezable,
IConstraintHolder {
    private List<ContainableModelElement> modelElements;
    private Version version;
    private List<ProjectImport> imports;
    private ProjectType type = new ProjectType(this);
    private int interfaceCount = 0;
    private Project parent;
    private Map<String, ContainableModelElement> names = new HashMap<String, ContainableModelElement>();
    private long timestamp = System.currentTimeMillis();
    private DecisionVariableDeclaration variable;
    private StructuredComment comment;

    Project() {
        super(null);
    }

    public Project(String name) {
        super(name);
        this.modelElements = new ArrayList<ContainableModelElement>();
        this.imports = new ArrayList<ProjectImport>();
        this.version = null;
        this.variable = new ProjectDecisionVariableDeclaration(name, (IDatatype)this.type, this);
    }

    public boolean addImport(ProjectImport pimport) {
        boolean found = false;
        if (!pimport.isConflict()) {
            int i = 0;
            while (!found && i < this.imports.size()) {
                ProjectImport tmp = this.imports.get(i);
                if (tmp.getProjectName().equals(pimport.getProjectName())) {
                    String ifName = tmp.getInterfaceName();
                    found = ifName == null ? pimport.getInterfaceName() == null : ifName.equals(pimport.getInterfaceName());
                }
                ++i;
            }
        }
        if (!found) {
            this.imports.add(pimport);
        }
        return !found;
    }

    public boolean removeImport(ProjectImport pimport) {
        boolean found = false;
        ProjectImport tmp = null;
        if (!pimport.isConflict()) {
            int i = 0;
            while (!found && i < this.imports.size()) {
                tmp = this.imports.get(i);
                if (tmp.getProjectName().equals(pimport.getProjectName())) {
                    String ifName = tmp.getInterfaceName();
                    found = ifName == null ? pimport.getInterfaceName() == null : ifName.equals(pimport.getInterfaceName());
                }
                ++i;
            }
        }
        if (found) {
            this.imports.remove((Object)tmp);
        }
        return found;
    }

    public boolean removeElements(List<ContainableModelElement> elementsToRemove) {
        boolean result = false;
        int i = 0;
        while (i < elementsToRemove.size()) {
            result |= this.removeElement(elementsToRemove.get(i));
            ++i;
        }
        return result;
    }

    public boolean removeElement(ContainableModelElement element) {
        this.names.remove(element.getName());
        this.names.remove(element.getQualifiedName());
        return this.modelElements.remove(element);
    }

    public void clear() {
        this.modelElements = new ArrayList<ContainableModelElement>();
        this.names.clear();
        this.imports = new ArrayList<ProjectImport>();
        int i = this.type.getOperationCount() - 1;
        while (i >= 0) {
            this.type.removeOperation(this.type.getOperation(i));
            --i;
        }
    }

    @Override
    public int getImportsCount() {
        return this.imports.size();
    }

    @Override
    public ProjectImport getImport(int index) {
        return this.imports.get(index);
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public ContainableModelElement getElement(int index) {
        return this.modelElements.get(index);
    }

    public Comment getCommentBefore(IModelElement element, boolean ensureStructured) {
        Comment result = null;
        if (this.modelElements != null) {
            int eltPos = this.modelElements.indexOf(element);
            if (eltPos >= 0) {
                IModelElement tmp;
                int pos = eltPos - 1;
                if (pos > 0 && (tmp = (IModelElement)this.modelElements.get(pos)) instanceof Comment) {
                    result = (Comment)tmp;
                }
                if (result == null && ensureStructured) {
                    result = new StructuredComment(null, this);
                    this.modelElements.add(eltPos, result);
                }
            }
        } else if (ensureStructured) {
            result = new StructuredComment(null, this);
        }
        return result;
    }

    @Override
    public int getElementCount() {
        return this.modelElements.size();
    }

    public boolean containsByName(String name) {
        return name != null && this.names.containsKey(name);
    }

    @Override
    public ContainableModelElement getElement(String name) {
        return name == null ? null : this.names.get(name);
    }

    public boolean addBeforeFreeze(ContainableModelElement element) {
        return this.add(element, () -> {
            int pos = this.modelElements.size();
            while (pos - 1 >= 0 && this.modelElements.get(pos - 1) instanceof FreezeBlock) {
                --pos;
            }
            return pos;
        });
    }

    public boolean add(ContainableModelElement element) {
        return this.add(element, null);
    }

    private boolean add(ContainableModelElement element, Supplier<Integer> position) {
        boolean found = false;
        if (element != null) {
            if (element instanceof OperationDefinition) {
                found = this.add((OperationDefinition)element);
            } else {
                if (!(element instanceof Attribute) && !(element instanceof AttributeAssignment) && element.getName() != null && element.getName().length() > 0) {
                    found = this.containsByName(element.getName());
                }
                if (!found) {
                    if (position == null) {
                        this.modelElements.add(element);
                    } else {
                        this.modelElements.add(position.get(), element);
                    }
                    if (element instanceof ProjectInterface) {
                        ++this.interfaceCount;
                    }
                    if (element.getName() != null) {
                        this.names.put(element.getName(), element);
                        this.names.put(element.getQualifiedName(), element);
                    }
                }
            }
        }
        return !found;
    }

    public boolean renameElement(ContainableModelElement elt, String newName) {
        return this.renameElement(elt.getName(), newName);
    }

    public boolean renameElement(String oldName, String newName) {
        boolean done = false;
        ContainableModelElement elt = this.getElement(oldName);
        if (elt != null && !newName.equals(oldName)) {
            this.names.remove(elt.getName());
            this.names.remove(elt.getQualifiedName());
            elt.setName(newName);
            this.names.put(elt.getName(), elt);
            this.names.put(elt.getQualifiedName(), elt);
            done = true;
        }
        return done;
    }

    public boolean add(OperationDefinition definition) {
        boolean found = false;
        String opSig = definition.getOperation().getSignature();
        int op = 0;
        int n = this.getOperationCount();
        while (!found && op < n) {
            found = opSig.equals(this.getOperation(op).getSignature());
            ++op;
        }
        if (!found) {
            this.modelElements.add(definition);
            this.type.addOperation(definition.getOperation());
        }
        return !found;
    }

    public boolean remove(OperationDefinition definition) {
        boolean result = false;
        result |= this.modelElements.remove(definition);
        return result |= this.type.removeOperation(definition.getOperation());
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitProject(this);
    }

    @Override
    public CustomOperation getOperation(int index) {
        return this.type.getOperation(index);
    }

    @Override
    public int getOperationCount() {
        return this.type.getOperationCount();
    }

    @Override
    public IDatatype getType() {
        return this.type;
    }

    public DecisionVariableDeclaration getVariable() {
        return this.variable;
    }

    @Override
    public boolean hasInterfaces() {
        return this.interfaceCount > 0;
    }

    @Override
    public boolean attribute(Attribute attribute) {
        return this.variable.attribute(attribute);
    }

    @Override
    public int getAttributesCount() {
        return this.variable.getAttributesCount();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.variable.getAttribute(name);
    }

    @Override
    public Attribute getAttribute(int index) {
        return this.variable.getAttribute(index);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public String getNameSpace() {
        Object namespace = this.parent == null ? this.getName() : this.parent.getNameSpace() + "::" + this.getName();
        return namespace;
    }

    @Override
    public Project getParent() {
        return this.parent;
    }

    void setParent(Project parent) {
        this.parent = parent;
    }

    public void setComments(StructuredComment comment) {
        this.comment = comment;
    }

    public StructuredComment getComments() {
        return this.comment;
    }

    public Comment getNestedComment(Object element) {
        Comment result = this.comment == null ? null : this.comment.getComment(element);
        return result;
    }

    public void sortContainedElements(Comparator<ContainableModelElement> comp) {
        assert (comp != null);
        int size = this.modelElements.size();
        Collections.sort(this.modelElements, comp);
        assert (this.modelElements.size() == size);
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        boolean successful = true;
        int m = 0;
        while (m < this.modelElements.size()) {
            successful &= this.modelElements.get(m).propagateAttribute(attribute);
            ++m;
        }
        return successful;
    }

    public ModelImport<Project> getSuper() {
        return null;
    }

    public IndentationConfiguration getIndentationConfiguration() {
        return null;
    }

    public void dispose() {
    }

    public IRestrictionEvaluationContext getRestrictionEvaluationContext() {
        return new LocalConfiguration();
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.add(constraint);
    }

    public long getLastModification() {
        return this.timestamp;
    }
}

