/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.BasicDecisionVariableContainer;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.EvaluationBlock;
import net.ssehub.easy.varModel.model.IConstraintHolder;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.StructuredDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class Compound
extends StructuredDatatype
implements IResolutionScope,
IDecisionVariableContainer,
IConstraintHolder {
    static final DelegatingType DTYPE = new DelegatingType(AnyType.DTYPE);
    public static final IDatatype TYPE = DTYPE;
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE).markAsAssignableParameterOperation();
    public static final Operation NOTEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation NOTEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation IF_DEFINED = new Operation(BooleanType.TYPE, "ifDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation COPY = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "copy", TYPE, AnyType.STRING_TYPE);
    private boolean isAbstract;
    private Compound[] refines;
    private BasicDecisionVariableContainer container;

    static {
        DTYPE.setDelegate(new Compound());
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(NOTEQUALS);
        DTYPE.addOperation(NOTEQUALS_ALIAS);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(IF_DEFINED);
        DTYPE.addOperation(COPY);
    }

    private Compound() {
        this("<Compound>", (ModelElement)null, (Compound[])null);
    }

    public Compound(String name, ModelElement parent) {
        this(name, parent, (Compound[])null);
    }

    public Compound(String name, ModelElement parent, Compound refines) {
        Compound[] compoundArray;
        if (refines == null) {
            compoundArray = null;
        } else {
            Compound[] compoundArray2 = new Compound[1];
            compoundArray = compoundArray2;
            compoundArray2[0] = refines;
        }
        this(name, parent, compoundArray);
    }

    public Compound(String name, ModelElement parent, Compound ... refines) {
        super(name, DTYPE, parent);
        this.container = new BasicDecisionVariableContainer();
        this.refines = refines;
    }

    public Compound(String name, ModelElement parent, boolean isAbstract, Compound refines) {
        Compound[] compoundArray;
        if (refines == null) {
            compoundArray = null;
        } else {
            Compound[] compoundArray2 = new Compound[1];
            compoundArray = compoundArray2;
            compoundArray2[0] = refines;
        }
        this(name, parent, isAbstract, compoundArray);
    }

    public Compound(String name, ModelElement parent, boolean isAbstract, Compound ... refines) {
        super(name, DTYPE, parent);
        this.container = new BasicDecisionVariableContainer();
        this.isAbstract = isAbstract;
        this.refines = refines;
    }

    public void setRefines(Compound[] refines) {
        this.refines = refines;
    }

    @Override
    public int getImportsCount() {
        return 0;
    }

    @Override
    public ProjectImport getImport(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean hasInterfaces() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    public int getRefinesCount() {
        return this.refines == null ? 0 : this.refines.length;
    }

    public Compound getRefines(int index) throws IndexOutOfBoundsException {
        if (this.refines == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.refines[index];
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitCompound(this);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitCompoundType(this);
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        boolean cmpMatches;
        boolean result = false;
        boolean classMatches = super.isAssignableFrom(type);
        boolean isMetaType = this.getType() == TYPE.getType() || type.getType() == TYPE.getType();
        boolean isTypeNull = AnyType.TYPE.getType() == type.getType();
        boolean bl = cmpMatches = this == type || isMetaType || isTypeNull;
        if (isTypeNull) {
            result = true;
        } else {
            if (!cmpMatches && type instanceof Compound) {
                cmpMatches = ((Compound)type).isRefinedFrom(this, true);
            }
            result = classMatches && cmpMatches;
        }
        return result;
    }

    @Override
    public boolean add(DecisionVariableDeclaration elem) {
        boolean alreadyIn = false;
        if (!alreadyIn) {
            alreadyIn = !this.container.add(elem);
        }
        return !alreadyIn;
    }

    public boolean containsByNameRefines(String name) {
        boolean contains = this.container.containsByName(name);
        int r = 0;
        while (!contains && r < this.getRefinesCount()) {
            contains = this.getRefines(r).containsByName(name);
            ++r;
        }
        return contains;
    }

    public boolean isRefinedFrom(Compound cmp, boolean transitive) {
        boolean refined = false;
        int r = 0;
        while (!refined && r < this.getRefinesCount()) {
            refined = this.getRefines(r) == cmp || transitive && this.getRefines(r).isRefinedFrom(cmp, true);
            ++r;
        }
        return refined;
    }

    @Override
    public int getElementCount() {
        return this.container.getElementCount();
    }

    @Override
    public DecisionVariableDeclaration getElement(int index) {
        return this.container.getElement(index);
    }

    public int getInheritedElementCount() {
        int elementCount = this.container.getDeclarationCount();
        int r = 0;
        while (r < this.getRefinesCount()) {
            elementCount += this.getRefines(r).getInheritedElementCount();
            ++r;
        }
        return elementCount;
    }

    public DecisionVariableDeclaration getInheritedElement(int index) {
        DecisionVariableDeclaration element = null;
        int inheritedCount = 0;
        int r = 0;
        while (element == null && r < this.getRefinesCount()) {
            Compound ref = this.getRefines(r);
            int last = inheritedCount;
            if (index < (inheritedCount += ref.getInheritedElementCount())) {
                element = ref.getInheritedElement(index - last);
            }
            ++r;
        }
        if (index >= inheritedCount) {
            element = this.getDeclaration(index - inheritedCount);
        }
        return element;
    }

    @Override
    public boolean contains(DecisionVariableDeclaration var) {
        return this.container.contains(var);
    }

    @Override
    public DecisionVariableDeclaration getElement(String name) {
        DecisionVariableDeclaration decl = this.container.getElement(name);
        int r = 0;
        while (decl == null && r < this.getRefinesCount()) {
            decl = this.getRefines(r).getElement(name);
            ++r;
        }
        return decl;
    }

    @Override
    public void addConstraint(Constraint constraint, boolean internal) {
        this.container.addConstraint(constraint, internal);
    }

    @Override
    public int getConstraintsCount() {
        return this.container.getConstraintsCount();
    }

    @Override
    public Constraint getConstraint(int index) {
        return this.container.getConstraint(index);
    }

    @Override
    public void sortContainedElements(Comparator<ContainableModelElement> comp) {
        this.container.sortContainedElements(comp);
    }

    @Override
    public ContainableModelElement getModelElement(int index) {
        return this.container.getModelElement(index);
    }

    @Override
    public int getModelElementCount() {
        return this.container.getModelElementCount();
    }

    @Override
    public void add(Comment comment) {
        this.container.add(comment);
    }

    @Override
    public void add(AttributeAssignment assignment) {
        this.container.add(assignment);
    }

    @Override
    public int getAssignmentCount() {
        return this.container.getAssignmentCount();
    }

    @Override
    public AttributeAssignment getAssignment(int index) {
        return this.container.getAssignment(index);
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        return this.container.propagateAttribute(attribute);
    }

    @Override
    public int getRealizingCount() {
        return this.container.getRealizingCount();
    }

    @Override
    public Constraint getRealizing(int index) {
        return this.container.getRealizing(index);
    }

    @Override
    public int getDeclarationCount() {
        return this.container.getDeclarationCount();
    }

    @Override
    public DecisionVariableDeclaration getDeclaration(int index) {
        return this.container.getDeclaration(index);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.addConstraint(constraint, false);
    }

    public boolean removeConstraint(ContainableModelElement element) {
        return this.container.removeModelElement(element);
    }

    @Override
    public void add(EvaluationBlock eval) {
        this.container.add(eval);
    }

    @Override
    public boolean containsByName(String name) {
        return this.container.containsByName(name);
    }

    @Override
    public void forceUpdate() {
        this.container.forceUpdate();
        if (this.refines != null) {
            int r = 0;
            while (r < this.getRefinesCount()) {
                this.getRefines(r).forceUpdate();
                ++r;
            }
        }
    }

    public int getRefinesDistanceTo(Compound cmp) {
        return this.getRefinesDistanceTo(cmp, true);
    }

    private int getRefinesDistanceTo(Compound cmp, boolean checkOpposite) {
        int result = -1;
        if (TypeQueries.sameTypes(cmp, this)) {
            result = 0;
        } else {
            result = this.findRefinesDistanceTo(result, cmp);
            if (checkOpposite) {
                result = cmp.findRefinesDistanceTo(result, this);
            }
        }
        return result;
    }

    private int findRefinesDistanceTo(int res, Compound cmp) {
        int result = res;
        int r = 0;
        while (result < 0 && r < cmp.getRefinesCount()) {
            int tmp = this.getRefinesDistanceTo(cmp.getRefines(r), false);
            if (tmp >= 0) {
                result = tmp + 1;
            }
            ++r;
        }
        return result;
    }

    public Collection<Compound> allImplementing(IResolutionScope scope) {
        List<Compound> candidates = ModelQuery.findRefining(scope, this);
        candidates.add(this);
        return candidates;
    }

    public Collection<Compound> implementingNonAbstract(IResolutionScope scope) {
        return Compound.pruneAbstract(this.allImplementing(scope));
    }

    public static Collection<Compound> pruneAbstract(Collection<Compound> compounds) {
        return Compound.prune(compounds, true);
    }

    public static Collection<Compound> pruneNonAbstract(Collection<Compound> compounds) {
        return Compound.prune(compounds, false);
    }

    private static Collection<Compound> prune(Collection<Compound> compounds, boolean pruneAbstract) {
        if (compounds != null) {
            Iterator<Compound> iter = compounds.iterator();
            while (iter.hasNext()) {
                Compound cmp = iter.next();
                if ((!pruneAbstract || !cmp.isAbstract()) && (pruneAbstract || cmp.isAbstract())) continue;
                iter.remove();
            }
        }
        return compounds;
    }

    public Collection<Compound> closestRefining(Collection<Compound> compounds) {
        int minDist = -1;
        ArrayList<Compound> result = new ArrayList<Compound>();
        for (Compound c : compounds) {
            int dist = this.getRefinesDistanceTo(c);
            if (dist < 0) continue;
            if (minDist < 0 || dist < minDist) {
                minDist = dist;
                result.clear();
                result.add(c);
                continue;
            }
            if (dist != minDist) continue;
            result.add(c);
        }
        return result;
    }
}

