/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public abstract class CustomDatatype
extends ContainableModelElement
implements IDatatype {
    private DelegatingType singleton;

    protected CustomDatatype(String name, DelegatingType singleton, IModelElement parent) {
        super(name, parent);
        this.singleton = singleton;
    }

    @Override
    public final Operation getOperation(int index) {
        return this.singleton.getOperation(index);
    }

    @Override
    public final int getOperationCount() {
        return this.singleton.getOperationCount();
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        return this.singleton.equals(type) || AnyType.TYPE == type || type != null && this.getClass().isAssignableFrom(type.getClass());
    }

    @Override
    public Class<? extends IDatatype> getTypeClass() {
        return this.singleton.getTypeClass();
    }

    @Override
    public IDatatype getType() {
        return this;
    }

    @Override
    public IDatatype getGenericType(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getGenericTypeCount() {
        return 0;
    }

    @Override
    public boolean isPseudoType() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    protected static final boolean isType(IDatatype requestedType, IDatatype type, IDatatype ... generics) {
        boolean match = false;
        if (requestedType.isAssignableFrom(type) && generics != null && generics.length == type.getGenericTypeCount()) {
            match = true;
            int g = 0;
            while (match && g < type.getGenericTypeCount()) {
                IDatatype generic = type.getGenericType(g);
                match = generic.isAssignableFrom(generics[g]) || generics[g].isAssignableFrom(generic);
                ++g;
            }
        }
        return match;
    }
}

