/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class Reference
extends CustomDatatype {
    static final DelegatingType DTYPE = new DelegatingType();
    public static final IDatatype TYPE = DTYPE;
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE);
    public static final Operation UNEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation UNEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation IF_DEFINED = new Operation(BooleanType.TYPE, "ifDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation COPY = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "copy", TYPE, AnyType.STRING_TYPE);
    public static final Operation REF_BY = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_DEREF, "refBy", TYPE, new IDatatype[0]);
    private IDatatype type;

    static {
        DTYPE.setDelegate(new Reference());
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(IF_DEFINED);
        DTYPE.addOperation(COPY);
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(UNEQUALS);
        DTYPE.addOperation(UNEQUALS_ALIAS);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(REF_BY);
    }

    private Reference() {
        this("<Reference>", (IDatatype)null, (ModelElement)null);
    }

    public Reference(String name, IDatatype type, ModelElement parent) {
        super(name, DTYPE, parent);
        this.type = type;
    }

    @Override
    public IDatatype getType() {
        return this.type;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitReference(this);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitReference(this);
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        boolean isAssignable;
        boolean bl = isAssignable = AnyType.TYPE == type;
        if (super.isAssignableFrom(type) && type instanceof Reference) {
            Reference r = (Reference)type;
            if (this.type == null) {
                isAssignable = true;
            } else if (r.type != null) {
                isAssignable = this.type.isAssignableFrom(DerivedDatatype.resolveToBasis(r.type));
            }
        }
        return isAssignable;
    }

    public static IDatatype dereference(IDatatype type) {
        IDatatype result = type instanceof Reference ? ((Reference)type).getType() : type;
        return result;
    }

    public static void dereference(IDatatype[] types) {
        if (types != null) {
            int p = 0;
            while (p < types.length) {
                types[p] = Reference.dereference(types[p]);
                ++p;
            }
        }
    }

    public static boolean isReferenceTo(IDatatype type, IDatatype parameter) {
        return TYPE.isAssignableFrom(type) && parameter.isAssignableFrom(type.getType());
    }
}

