/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BasisDatatype;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.RealType;

public class StringType
extends BasisDatatype {
    static final DelegatingType DTYPE = AnyType.STRING_TYPE;
    public static final IDatatype TYPE = DTYPE;
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE);
    public static final Operation UNEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation UNEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation EQUALS_IGNORE_CASE = new Operation(BooleanType.TYPE, "equalsIgnoreCase", TYPE, TYPE);
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation IF_DEFINED = new Operation(BooleanType.TYPE, "ifDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation SIZE = new Operation(IntegerType.TYPE, "size", TYPE, new IDatatype[0]);
    public static final Operation TO_INTEGER = new Operation(IntegerType.TYPE, "toInteger", TYPE, new IDatatype[0]);
    public static final Operation TO_REAL = new Operation(RealType.TYPE, "toReal", TYPE, new IDatatype[0]);
    public static final Operation PLUS = Operation.createInfixOperator(TYPE, "+", TYPE, TYPE);
    public static final Operation CONCAT = new Operation(TYPE, "concat", TYPE, TYPE);
    public static final Operation SUBSTRING = new Operation(TYPE, "substring", TYPE, IntegerType.TYPE, IntegerType.TYPE);
    public static final Operation TO_UPPER_CASE = new Operation(TYPE, "toUpperCase", TYPE, new IDatatype[0]);
    public static final Operation TO_LOWER_CASE = new Operation(TYPE, "toLowerCase", TYPE, new IDatatype[0]);
    public static final Operation INDEX_OF = new Operation(IntegerType.TYPE, "indexOf", TYPE, TYPE);
    public static final Operation AT = new Operation(TYPE, "at", TYPE, IntegerType.TYPE);
    public static final Operation MATCHES = new Operation(BooleanType.TYPE, "matches", TYPE, TYPE);
    public static final Operation SUBSTITUTES = new Operation(TYPE, "substitutes", TYPE, TYPE, TYPE);
    public static final Operation TO_STRING = new Operation(TYPE, "toString", TYPE, new IDatatype[0]);
    public static final Operation TO_BOOLEAN = new Operation(BooleanType.TYPE, "toBoolean", TYPE, new IDatatype[0]);
    public static final Operation CHARACTERS = new Operation((IDatatype)AnyType.SEQUENCE_TYPE, "characters", TYPE, new IDatatype[0]);
    public static final Operation LESS = Operation.createInfixOperator(BooleanType.TYPE, "<", TYPE, TYPE);
    public static final Operation LESS_EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<=", TYPE, TYPE);
    public static final Operation GREATER = Operation.createInfixOperator(BooleanType.TYPE, ">", TYPE, TYPE);
    public static final Operation GREATER_EQUALS = Operation.createInfixOperator(BooleanType.TYPE, ">=", TYPE, TYPE);
    public static final Operation COPY = new Operation(TYPE, "copy", TYPE, TYPE);

    static {
        DTYPE.setDelegate(new StringType());
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(UNEQUALS);
        DTYPE.addOperation(UNEQUALS_ALIAS);
        DTYPE.addOperation(EQUALS_IGNORE_CASE);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(IF_DEFINED);
        DTYPE.addOperation(COPY);
        DTYPE.addOperation(SIZE);
        DTYPE.addOperation(TO_INTEGER);
        DTYPE.addOperation(TO_REAL);
        DTYPE.addOperation(PLUS);
        DTYPE.addOperation(CONCAT);
        DTYPE.addOperation(SUBSTRING);
        DTYPE.addOperation(TO_UPPER_CASE);
        DTYPE.addOperation(TO_LOWER_CASE);
        DTYPE.addOperation(INDEX_OF);
        DTYPE.addOperation(AT);
        DTYPE.addOperation(MATCHES);
        DTYPE.addOperation(SUBSTITUTES);
        DTYPE.addOperation(TO_STRING);
        DTYPE.addOperation(TO_BOOLEAN);
        DTYPE.addOperation(CHARACTERS);
        DTYPE.addOperation(LESS);
        DTYPE.addOperation(LESS_EQUALS);
        DTYPE.addOperation(GREATER);
        DTYPE.addOperation(GREATER_EQUALS);
    }

    private StringType() {
        super("String", DTYPE);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitStringType(this);
    }
}

