/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.datatypes.Reference;

class ConstraintClassifier
implements IConstraintTreeVisitor {
    private ExpectedType nextType = ExpectedType.OCL_FEATURE_CALL;
    private boolean isAssingmentConstraint = true;

    ConstraintClassifier(ConstraintSyntaxTree tree) {
        tree.accept(this);
    }

    boolean isAssingmentConstraint() {
        return this.isAssingmentConstraint;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        if (this.nextType != ExpectedType.CONSTANT_VALUE) {
            this.isAssingmentConstraint = false;
        }
    }

    @Override
    public void visitVariable(Variable variable) {
        if (this.nextType == ExpectedType.VARIABLE && variable.getVariable().getType() == Reference.TYPE) {
            this.nextType = ExpectedType.REFERENCE_VALUE;
        } else if (this.nextType != ExpectedType.VARIABLE) {
            this.isAssingmentConstraint = false;
        }
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer init) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer init) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitComment(Comment parenthesis) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (this.nextType == ExpectedType.OCL_FEATURE_CALL && call.getOperation().equals("=") && call.getParameterCount() == 1) {
            this.nextType = ExpectedType.VARIABLE;
            call.getOperand().accept(this);
            if (ExpectedType.REFERENCE_VALUE != this.nextType) {
                this.nextType = ExpectedType.CONSTANT_VALUE;
            }
            call.getParameter(0).accept(this);
        } else if (this.nextType == ExpectedType.CONSTANT_VALUE && call.getOperation().equals("[]")) {
            call.getParameter(0).accept(this);
        } else {
            this.isAssingmentConstraint = false;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        this.isAssingmentConstraint = false;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        if (this.nextType != ExpectedType.VARIABLE) {
            this.isAssingmentConstraint = false;
        }
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        ConstraintSyntaxTree actual = expression.getActualExpression();
        if (actual != null) {
            actual.accept(this);
        }
    }

    @Override
    public void visitSelf(Self self) {
        if (this.nextType != ExpectedType.VARIABLE) {
            this.isAssingmentConstraint = false;
        }
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        this.isAssingmentConstraint = false;
    }

    private static enum ExpectedType {
        VARIABLE,
        OCL_FEATURE_CALL,
        CONSTANT_VALUE,
        REFERENCE_VALUE;

    }
}

