/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter.mandatoryVars;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.Context;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.Importance;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.MandatoryClassifierSettings;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.VariableContainer;

public class MandatoryDeclarationClassifier
extends AbstractProjectVisitor
implements IConstraintTreeVisitor {
    private VariableContainer varContainer;
    private Context context;
    private MandatoryClassifierSettings settings;
    private Map<IDatatype, List<AbstractVariable>> declarationsByType = new HashMap<IDatatype, List<AbstractVariable>>();
    private boolean nextVarIsMandatory;

    public MandatoryDeclarationClassifier(Configuration config, FilterType filterType) {
        this(config, filterType, new MandatoryClassifierSettings());
    }

    public MandatoryDeclarationClassifier(Configuration config, FilterType filterType, MandatoryClassifierSettings settings) {
        super(config.getProject(), filterType);
        this.settings = settings;
        this.varContainer = new VariableContainer(config, this.settings);
        this.context = new Context();
        this.nextVarIsMandatory = false;
    }

    public VariableContainer getImportances() {
        return this.varContainer;
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        IDatatype type = decl.getType();
        ConstraintSyntaxTree constraint = decl.getDefaultValue();
        if (ConstraintType.isConstraint(type) && constraint != null) {
            constraint.accept(this);
        }
        if (this.settings.considerDefaultValues() && decl.getDefaultValue() != null) {
            this.varContainer.setImportance(decl.getQualifiedName(), Importance.OPTIONAL);
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        this.context.clear();
        ConstraintSyntaxTree syntax = constraint.getConsSyntax();
        IModelElement parent = constraint.getParent();
        if (syntax != null) {
            if (parent instanceof Project || parent instanceof DerivedDatatype) {
                syntax.accept(this);
            } else if (parent instanceof Compound) {
                Compound cType = (Compound)parent;
                this.context.addParent(cType.getQualifiedName());
                syntax.accept(this);
                if (this.context.elementsWereFound()) {
                    this.varContainer.setImportance(cType.getQualifiedName(), Importance.MANDATORY);
                }
            }
        }
    }

    private List<AbstractVariable> getDeclarationsByType(IDatatype type) {
        List<AbstractVariable> declarations = this.declarationsByType.get(type);
        if (declarations == null) {
            DeclarationFinder finder = new DeclarationFinder(this.getStartingProject(), this.getFilterType(), type, false);
            declarations = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ALL);
            int i = declarations.size() - 1;
            while (i >= 0) {
                IDatatype declType = declarations.get(i).getType();
                boolean delete = declType != type;
                while (delete && declType instanceof DerivedDatatype) {
                    boolean bl = delete = (declType = ((DerivedDatatype)declType).getBasisType()) != type;
                }
                if (delete) {
                    declarations.remove(i);
                }
                --i;
            }
            this.declarationsByType.put(type, declarations);
        }
        return declarations;
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitEnum(Enum eenum) {
        if (this.settings.treatEnumsAsMandatory()) {
            List<AbstractVariable> variables = this.getDeclarationsByType(eenum);
            int i = 0;
            int n = variables.size();
            while (i < n) {
                this.setImportanceForAllInstancesOfDeclaration(variables.get(i), Importance.MANDATORY);
                ++i;
            }
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.visitEnum(eenum);
    }

    private void setImportanceForAllInstancesOfDeclaration(AbstractVariable decl, Importance importance) {
        this.varContainer.setImportance(decl.getQualifiedName(), importance);
    }

    @Override
    public void visitCompound(Compound compound) {
        int r = 0;
        while (r < compound.getRefinesCount()) {
            this.visitCompound(compound.getRefines(r));
            ++r;
        }
        int i = 0;
        int n = compound.getConstraintsCount();
        while (i < n) {
            this.visitConstraint(compound.getConstraint(i));
            ++i;
        }
        i = 0;
        int end = compound.getInheritedElementCount();
        while (i < end) {
            this.visitDecisionVariableDeclaration(compound.getInheritedElement(i));
            ++i;
        }
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        int nConstraints = datatype.getConstraintCount();
        int i = 0;
        while (i < nConstraints) {
            Constraint constraint = datatype.getConstraint(i);
            if (constraint != null) {
                this.visitConstraint(constraint);
            }
            ++i;
        }
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
    }

    @Override
    public void visitSequence(Sequence sequence) {
    }

    @Override
    public void visitSet(Set set) {
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
        AbstractVariable decl = variable.getVariable();
        if (this.nextVarIsMandatory) {
            IModelElement parent = decl.getParent();
            if (parent instanceof DerivedDatatype) {
                List<AbstractVariable> instances = this.getDeclarationsByType((DerivedDatatype)parent);
                if (instances != null) {
                    int i = 0;
                    int end = instances.size();
                    while (i < end) {
                        this.setImportanceForAllInstancesOfDeclaration(instances.get(i), Importance.MANDATORY);
                        ++i;
                    }
                }
            } else {
                String qName = this.context.hasParent() ? this.getSlotOfCompound(decl) : decl.getQualifiedName();
                this.context.elementFound();
                this.varContainer.setImportance(qName, Importance.MANDATORY);
                if (this.context.depth() > 0) {
                    this.context.addParent(qName);
                }
            }
        }
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        String op = call.getOperation();
        ConstraintSyntaxTree operand = call.getOperand();
        if ("isDefined".equals(op)) {
            this.nextVarIsMandatory = true;
            operand.accept(this);
            this.nextVarIsMandatory = false;
        } else if (!"=".equals(op) && operand != null) {
            operand.accept(this);
            int i = 0;
            while (i < call.getParameterCount()) {
                call.getParameter(i).accept(this);
                ++i;
            }
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        String nestedVar;
        this.context.compoundDown();
        access.getCompoundExpression().accept(this);
        AbstractVariable slotDecl = access.getResolvedSlot();
        if (slotDecl != null && this.context.hasParent() && (nestedVar = this.getSlotOfCompound(access.getResolvedSlot())) != null) {
            this.context.elementFound();
            this.varContainer.setImportance(nestedVar, Importance.MANDATORY);
            if (this.context.depth() > 1) {
                this.context.addParent(nestedVar);
            }
        }
        this.context.compoundUp();
        if (this.context.depth() == 0) {
            this.context.clear();
        }
    }

    private String getSlotOfCompound(AbstractVariable slotDeclaration) {
        String qName = null;
        String pName = this.context.getParent();
        if (pName != null) {
            qName = pName + "::" + slotDeclaration.getName();
        }
        return qName;
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

