/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExplicitTypeVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ValueCopyVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class CSTCopyVisitor
extends CopyVisitor {
    private boolean visitItrExpression;
    private boolean complete;
    private ProjectCopyVisitor copyier;
    private boolean forceAccessors;

    CSTCopyVisitor(Map<AbstractVariable, AbstractVariable> mapping, ProjectCopyVisitor copyier) {
        super(mapping);
        this.setCopyExpressions(true);
        this.copyier = copyier;
        this.complete = true;
        this.visitItrExpression = false;
        this.forceAccessors = false;
    }

    void setForceaccessors(boolean forceAccessors) {
        this.forceAccessors = forceAccessors;
    }

    boolean translatedCompletely() {
        return this.complete;
    }

    @Override
    protected AbstractVariable mapVariable(AbstractVariable var) {
        AbstractVariable result = null;
        if (this.getMapping() != null) {
            result = this.getMapping().get(var);
            if (result == null && var instanceof Attribute && var.getParent() != null && this.copyier.getCopiedParent(var.getParent()) != null) {
                result = this.mapAnnotation((Attribute)var);
            }
            if (result == null && this.visitItrExpression && var instanceof DecisionVariableDeclaration) {
                DecisionVariableDeclaration varAsDecl = (DecisionVariableDeclaration)var;
                IDatatype cpiedType = this.copyier.getTranslatedType(var.getType());
                IModelElement copiedParent = this.copyier.getCopiedParent(var.getParent());
                if (cpiedType != null && copiedParent != null) {
                    result = varAsDecl.isDeclaratorTypeExplicit() ? new ExplicitTypeVariableDeclaration(var.getName(), cpiedType, copiedParent) : new DecisionVariableDeclaration(var.getName(), cpiedType, copiedParent);
                    this.getMapping().put(var, result);
                }
            }
            if (result == null) {
                result = var;
                if (this.copyier == null || !this.copyier.getAllCopiedProjects().contains(result.getTopLevelParent())) {
                    this.complete = false;
                }
            }
        } else {
            result = var;
        }
        return result;
    }

    private AbstractVariable mapAnnotation(Attribute var) {
        Attribute annotation;
        Attribute result;
        IModelElement parent = this.copyier.getCopiedParent(var.getParent());
        IAttributableElement orgAttributed = var.getElement();
        IAttributableElement copiedAttributed = (IAttributableElement)((Object)this.getMapping().get(orgAttributed));
        Attribute attribute = result = copiedAttributed != null ? copiedAttributed.getAttribute(var.getName()) : null;
        if (copiedAttributed != null && result == null && parent != null && parent instanceof IAttributeAccess && (annotation = ((IAttributeAccess)((Object)parent)).getAttribute(var.getName())) != null) {
            parent.propagateAttribute(annotation);
            result = copiedAttributed.getAttribute(var.getName());
        }
        if (result == null) {
            IAttributableElement annotatedElement;
            if (parent instanceof AttributeAssignment && (annotatedElement = var.getElement()) instanceof IModelElement) {
                parent = (IModelElement)((Object)annotatedElement);
            }
            if (parent instanceof IAttributableElement) {
                result = ((IAttributableElement)((Object)parent)).getAttribute(var.getName());
            }
        }
        if (result != null) {
            this.getMapping().put(var, result);
        }
        return result;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (this.complete) {
            ConstraintSyntaxTree operand = call.getOperand();
            if (operand != null) {
                operand.accept(this);
                operand = this.getResult();
            } else {
                operand = null;
            }
            ConstraintSyntaxTree[] args = new ConstraintSyntaxTree[call.getParameterCount()];
            int p = 0;
            while (p < args.length) {
                call.getParameter(p).accept(this);
                args[p] = this.getResult();
                ++p;
            }
            ICustomOperationAccessor accessor = call.getAccessor();
            if (accessor != null) {
                ICustomOperationAccessor copiedAccessor = this.copyier.getCopiedAccessor(accessor);
                if (copiedAccessor == null && this.forceAccessors && accessor instanceof Project) {
                    Project orgAcessor = (Project)accessor;
                    Iterator<Project> copiedProjectsItr = this.copyier.getAllCopiedProjects().iterator();
                    while (copiedAccessor == null && copiedProjectsItr.hasNext()) {
                        Project candidate = copiedProjectsItr.next();
                        if (!orgAcessor.getName().equals(candidate.getName())) continue;
                        copiedAccessor = candidate;
                    }
                }
                if (copiedAccessor != null) {
                    accessor = copiedAccessor;
                } else {
                    this.complete = false;
                }
            }
            if (this.complete) {
                this.setResult(new OCLFeatureCall(operand, call.getOperation(), accessor, args));
            } else {
                this.setResult(call);
            }
        } else {
            this.setResult(call);
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        if (this.complete) {
            String[] slots = new String[initializer.getSlotCount()];
            int s = 0;
            while (s < slots.length) {
                slots[s] = initializer.getSlot(s);
                ++s;
            }
            AbstractVariable[] slotDecls = new DecisionVariableDeclaration[initializer.getSlotCount()];
            int s2 = 0;
            while (s2 < slotDecls.length) {
                slotDecls[s2] = this.mapVariable(initializer.getSlotDeclaration(s2));
                ++s2;
            }
            ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
            int e = 0;
            while (e < exprs.length) {
                initializer.getExpression(e).accept(this);
                exprs[e] = this.getResult();
                ++e;
            }
            IDatatype copiedType = this.copyier.getTranslatedType(initializer.getType());
            if (copiedType != null && copiedType instanceof Compound) {
                try {
                    assert (initializer.getType().getClass() == copiedType.getClass());
                    this.setResult(new CompoundInitializer((Compound)copiedType, slots, slotDecls, exprs));
                }
                catch (CSTSemanticException e2) {
                    this.complete = false;
                    this.setResult(initializer);
                    EASyLoggerFactory.INSTANCE.getLogger(CSTCopyVisitor.class, "net.ssehub.easy.varModel").exception((Exception)e2);
                }
            } else {
                this.complete = false;
                this.setResult(initializer);
            }
        } else {
            this.setResult(initializer);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        if (this.complete) {
            ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
            int e = 0;
            while (e < exprs.length) {
                initializer.getExpression(e).accept(this);
                exprs[e] = this.getResult();
                ++e;
            }
            IDatatype copiedType = this.copyier.getTranslatedType(initializer.getType());
            if (copiedType != null && copiedType instanceof Container) {
                try {
                    assert (initializer.getType().getClass() == copiedType.getClass());
                    this.setResult(new ContainerInitializer((Container)copiedType, exprs));
                }
                catch (CSTSemanticException e2) {
                    this.complete = false;
                    this.setResult(initializer);
                    EASyLoggerFactory.INSTANCE.getLogger(CSTCopyVisitor.class, "net.ssehub.easy.varModel").exception((Exception)e2);
                }
            } else {
                this.complete = false;
                this.setResult(initializer);
            }
        } else {
            this.setResult(initializer);
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        ConstraintSyntaxTree container = this.getResult();
        this.visitItrExpression = true;
        call.getExpression().accept(this);
        this.visitItrExpression = false;
        ConstraintSyntaxTree expression = this.getResult();
        DecisionVariableDeclaration[] decls = new DecisionVariableDeclaration[call.getDeclaratorsCount()];
        int d = 0;
        while (d < decls.length) {
            DecisionVariableDeclaration orgDeclarator = call.getDeclarator(d);
            decls[d] = this.mapVariable(orgDeclarator);
            if (orgDeclarator.getDefaultValue() != null && decls[d].getDefaultValue() == null) {
                CSTCopyVisitor dfltValueCopyier = new CSTCopyVisitor(this.getMapping(), this.copyier);
                orgDeclarator.getDefaultValue().accept(dfltValueCopyier);
                if (dfltValueCopyier.translatedCompletely()) {
                    ConstraintSyntaxTree copiedDefault = dfltValueCopyier.getResult();
                    try {
                        decls[d].setValue(copiedDefault);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        this.complete = false;
                    }
                    catch (CSTSemanticException e) {
                        this.complete = false;
                    }
                } else {
                    this.complete = false;
                }
            }
            ++d;
        }
        this.setResult(new ContainerOperationCall(container, call.getOperation(), expression, decls));
    }

    @Override
    protected DecisionVariableDeclaration mapVariable(DecisionVariableDeclaration var) {
        DecisionVariableDeclaration resultDecl = null;
        AbstractVariable tmpDecl = null;
        if (this.getMapping() != null && (tmpDecl = this.getMapping().get(var)) != null) {
            IModelElement declsParent = tmpDecl.getTopLevelParent();
            if (tmpDecl instanceof DecisionVariableDeclaration && declsParent != null && this.copyier.getAllCopiedProjects().contains(declsParent)) {
                resultDecl = (DecisionVariableDeclaration)tmpDecl;
            }
        }
        if (resultDecl == null && this.copyier != null) {
            IDatatype copiedType = this.copyier.getTranslatedType(var.getType());
            IModelElement orgParent = var.getParent();
            ContainableModelElement parent = null;
            if (orgParent != null && orgParent instanceof ContainableModelElement) {
                parent = this.copyier.getCopiedElement((ContainableModelElement)orgParent);
            }
            if (orgParent != null && parent == null) {
                this.complete = false;
            }
            if (copiedType != null) {
                resultDecl = var.isDeclaratorTypeExplicit() ? new ExplicitTypeVariableDeclaration(var.getName(), copiedType, parent) : new DecisionVariableDeclaration(var.getName(), copiedType, parent);
            }
        }
        if (resultDecl == null) {
            resultDecl = super.mapVariable(var);
            this.complete = false;
        }
        return resultDecl;
    }

    @Override
    public void visitConstantValue(ConstantValue constantValue) {
        Value nestedValue = constantValue.getConstantValue();
        IDatatype type = nestedValue.getType();
        if (type != null && !type.isPrimitive()) {
            boolean tmpComplete = this.complete;
            this.complete = false;
            IDatatype copiedType = this.copyier.getTranslatedType(type);
            if (copiedType != null) {
                ValueCopyVisitor valueCopyier = new ValueCopyVisitor(this.copyier);
                nestedValue.accept(valueCopyier);
                if (valueCopyier.translatedCompletely()) {
                    this.setResult(new ConstantValue(valueCopyier.getResult()));
                    this.complete = tmpComplete;
                }
            }
        } else {
            super.visitConstantValue(constantValue);
        }
    }

    @Override
    public void visitSelf(Self self) {
        if (this.complete && this.copyier != null) {
            IDatatype copiedType = this.copyier.getTranslatedType(self.getType());
            if (copiedType != null && copiedType instanceof Compound) {
                this.setResult(new Self((Compound)copiedType));
            } else {
                this.complete = false;
                super.visitSelf(self);
            }
        } else {
            super.visitSelf(self);
        }
    }

    @Override
    protected void setResult(ConstraintSyntaxTree cst) {
        super.setResult(this.inferDatatype(cst));
    }
}

