/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.rewrite.UncopiedElementsContainer;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class UncopiedElement {
    private String type;
    private String name;
    private String parentName;
    private String uncopiedPart;

    UncopiedElement(ContainableModelElement originalElement) {
        this.type = originalElement.getClass().getSimpleName();
        this.name = originalElement.getName();
        IModelElement parent = originalElement.getParent();
        this.parentName = parent != null ? parent.getName() : null;
        this.uncopiedPart = StringProvider.toIvmlString(originalElement);
    }

    UncopiedElement(UncopiedElementsContainer.UnresolvedSyntaxContainer cstContainer) {
        this(cstContainer.getCopiedParent());
        this.uncopiedPart = StringProvider.toIvmlString(cstContainer.getOriginalSyntax());
    }

    UncopiedElement(UncopiedElementsContainer.UnresolvedAnnotationAssignment assignment) {
        this(assignment.getCopiedParent());
        this.type = assignment.getUnresolvedAssignment().getClass().getSimpleName();
        this.uncopiedPart = StringProvider.toIvmlString(assignment.getUnresolvedAssignment().getExpression());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getUncopiedPart() {
        return this.uncopiedPart;
    }

    public String getDescription() {
        StringBuffer description = new StringBuffer("Element \"");
        description.append(this.type);
        description.append(" ");
        description.append(this.name);
        description.append("\" in parent \"");
        description.append(this.parentName);
        description.append("\" problematic part: ");
        description.append(this.uncopiedPart);
        return description.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

