/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.rewrite.CSTCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.model.values.VersionValue;

class ValueCopyVisitor
implements IValueVisitor {
    private Value result;
    private ProjectCopyVisitor copyier;
    private boolean complete;

    ValueCopyVisitor(ProjectCopyVisitor copyier) {
        this.copyier = copyier;
        this.complete = true;
    }

    Value getResult() {
        return this.result;
    }

    boolean translatedCompletely() {
        return this.complete;
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
        if (value.getValue() != null) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copyier.getDeclarationMapping(), this.copyier);
            value.getValue().accept(cstCopyier);
            if (cstCopyier.translatedCompletely()) {
                try {
                    this.result = ValueFactory.createValue(value.getContainedType(), cstCopyier.getResult());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.result = value;
                    this.complete = false;
                }
            } else {
                this.result = value;
                this.complete = false;
            }
        }
    }

    @Override
    public void visitEnumValue(EnumValue value) {
        Enum copiedType = (Enum)this.copyier.getTranslatedType(value.getType());
        if (copiedType != null) {
            EnumLiteral lit = copiedType.get(value.getValue().getName());
            try {
                this.result = ValueFactory.createValue(copiedType, lit);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitStringValue(StringValue value) {
        this.result = value;
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
        Compound orgType = (Compound)value.getType();
        Compound cType = (Compound)this.copyier.getTranslatedType(orgType);
        int nOrgElements = orgType.getInheritedElementCount();
        if (cType != null && nOrgElements != cType.getInheritedElementCount()) {
            cType.forceUpdate();
        }
        if (cType != null && nOrgElements == cType.getInheritedElementCount()) {
            ArrayList<Object> copiedValues = new ArrayList<Object>();
            int i = 0;
            int n = cType.getInheritedElementCount();
            while (i < n) {
                String slotName = cType.getInheritedElement(i).getName();
                Value nestedValue = value.getNestedValue(slotName);
                if (nestedValue != null) {
                    nestedValue.accept(this);
                    if (this.result != null) {
                        copiedValues.add(slotName);
                        copiedValues.add(this.result);
                    }
                }
                ++i;
            }
            try {
                this.result = ValueFactory.createValue(cType, copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
        Container conType = (Container)this.copyier.getTranslatedType(value.getType());
        if (conType != null) {
            ArrayList<Value> copiedValues = new ArrayList<Value>();
            int i = 0;
            int n = value.getElementSize();
            while (i < n) {
                value.getElement(i).accept(this);
                if (this.result != null) {
                    copiedValues.add(this.result);
                }
                ++i;
            }
            try {
                this.result = ValueFactory.createValue(conType, copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitIntValue(IntValue value) {
        this.result = value;
    }

    @Override
    public void visitRealValue(RealValue value) {
        this.result = value;
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
        this.result = value;
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
        AbstractVariable referencedDecl = referenceValue.getValue();
        ConstraintSyntaxTree refCST = referenceValue.getValueEx();
        IDatatype refType = this.copyier.getTranslatedType(referenceValue.getType());
        if (referencedDecl != null) {
            AbstractVariable copiedDecl = (AbstractVariable)this.copyier.getCopiedElement(referencedDecl);
            if (copiedDecl != null && refType != null) {
                try {
                    this.result = ValueFactory.createValue(refType, copiedDecl);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    Bundle.getLogger(ValueCopyVisitor.class).exception((Exception)e);
                }
            } else {
                this.result = referenceValue;
                this.complete = false;
            }
        } else if (refCST != null) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copyier.getDeclarationMapping(), this.copyier);
            refCST.accept(cstCopyier);
            if (cstCopyier.translatedCompletely()) {
                try {
                    this.result = ValueFactory.createValue(refType, cstCopyier.getResult());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.result = referenceValue;
                    this.complete = false;
                }
            } else {
                this.result = referenceValue;
                this.complete = false;
            }
        } else {
            this.result = referenceValue;
            this.complete = false;
        }
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
        this.result = value;
    }

    @Override
    public void visitNullValue(NullValue value) {
        this.result = NullValue.INSTANCE;
    }

    @Override
    public void visitVersionValue(VersionValue value) {
        this.result = value;
    }
}

