/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.QualifiedNameMode;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.search.SearchContext;
import net.ssehub.easy.varModel.model.search.SearchResult;

public class PrefixSearchVisitor
extends AbstractVisitor
implements IConstraintTreeVisitor {
    private static final List<PrefixSearchVisitor> INSTANCES = new ArrayList<PrefixSearchVisitor>();
    private List<SearchResult> result = new ArrayList<SearchResult>();
    private HashSet<Object> inResult = new HashSet();
    private Class<?>[] restrictions;
    private String prefix;
    private DatatypeVisitor datatypeVisitor;
    private SearchContext context;
    private Stack<Project> nesting = new Stack();
    private boolean inInterface = false;

    private PrefixSearchVisitor() {
    }

    public static final synchronized PrefixSearchVisitor getInstance(String prefix, DatatypeVisitor datatypeVisitor, SearchContext context, Class<?> ... restrictions) {
        PrefixSearchVisitor result = !INSTANCES.isEmpty() ? INSTANCES.remove(INSTANCES.size() - 1) : new PrefixSearchVisitor();
        result.prepareInstance(prefix, datatypeVisitor, context, restrictions);
        return result;
    }

    public static final synchronized void release(PrefixSearchVisitor visitor) {
        visitor.clear();
        visitor.restrictions = null;
        visitor.prefix = "";
        visitor.datatypeVisitor = null;
        visitor.context = null;
        visitor.nesting.clear();
        visitor.inInterface = false;
        INSTANCES.add(visitor);
    }

    private void prepareInstance(String prefix, DatatypeVisitor datatypeVisitor, SearchContext context, Class<?> ... restrictions) {
        this.prefix = prefix;
        this.context = context == null ? SearchContext.ALL : context;
        this.datatypeVisitor = datatypeVisitor;
        this.datatypeVisitor.setQualifiedNameMode(QualifiedNameMode.QUALIFIED);
        this.restrictions = restrictions;
        if (context != null && context.includeOperations()) {
            int oCount = Operation.getOperationsCount();
            int o = 0;
            while (o < oCount) {
                Operation op = Operation.getOperation(o);
                this.checkName(op.getName(), op);
                ++o;
            }
        }
    }

    public List<SearchResult> getResult() {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        result.addAll(this.result);
        return result;
    }

    public void clear() {
        this.result.clear();
        this.inResult.clear();
    }

    private void checkName(String name, Object element) {
        if (name != null && name.startsWith(this.prefix)) {
            boolean restricted = false;
            if (this.restrictions != null && element != null) {
                int r = 0;
                while (!restricted && r < this.restrictions.length) {
                    restricted = this.restrictions[r] == element.getClass();
                    ++r;
                }
            }
            if (!restricted) {
                this.result.add(new SearchResult(name, element));
                this.inResult.add(element);
            }
        }
    }

    private void checkName(ModelElement element) {
        if (this.context.includeUnqualifiedNames()) {
            this.checkName(element.getName(), element);
        }
        if (this.context.includeQualifiedNames()) {
            this.checkName(element.getQualifiedName(), element);
        }
    }

    private String checkType(IDatatype type, ModelElement element) {
        type.accept(this.datatypeVisitor);
        String name = this.datatypeVisitor.getResult();
        this.checkName(name, element);
        this.datatypeVisitor.clear();
        return name;
    }

    private boolean resultContains(Object object) {
        return this.inResult.contains(object);
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        this.checkName(pImport.getProjectName(), (Object)pImport);
        if (pImport.getResolved() != null) {
            ((Project)pImport.getResolved()).accept(this);
        }
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        boolean consider = this.context.includeUnqualifiedNames();
        if (this.inInterface) {
            consider &= 1 == this.nesting.size() || !this.nesting.peek().hasInterfaces();
        }
        if (consider && !this.resultContains(decl)) {
            this.checkName(decl);
            this.checkType(decl.getType(), decl);
            int aCount = decl.getAttributesCount();
            int a = 0;
            while (a < aCount) {
                decl.accept(this);
                ++a;
            }
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkName(attribute);
        this.checkType(attribute.getType(), attribute);
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (this.context.includeConstraints()) {
            constraint.getConsSyntax().accept(this);
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        this.checkName(opdef);
        if (this.context.includeOperationDefinitions()) {
            CustomOperation operation = opdef.getOperation();
            int pCount = operation.getParameterCount();
            int p = 0;
            while (p < pCount) {
                this.checkName(operation.getParameterDeclaration(p));
                ++p;
            }
        }
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        if (this.context.includeEvals()) {
            int eCount = block.getEvaluableCount();
            int e = 0;
            while (e < eCount) {
                block.getEvaluable(e).accept(this);
                ++e;
            }
        }
    }

    @Override
    public void visitProject(Project project) {
        this.nesting.push(project);
        project.getVariable().accept(this);
        super.visitProject(project);
        this.nesting.pop();
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.checkName(eenum);
        super.visitEnum(eenum);
    }

    @Override
    public void visitCompound(Compound compound) {
        this.checkName(compound);
        super.visitCompound(compound);
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        if (this.nesting.size() > 1) {
            this.inInterface = true;
            int eCount = iface.getExportsCount();
            int e = 0;
            while (e < eCount) {
                iface.getExport(e).accept(this);
                ++e;
            }
            this.inInterface = false;
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.visitEnum(eenum);
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.checkName(datatype);
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
        this.checkName(literal.getQualifiedName(), literal);
    }

    @Override
    public void visitReference(Reference reference) {
        String name = this.checkType(reference, reference);
        if (name.startsWith("refTo")) {
            this.checkName("refBy" + name.substring(0, "refTo".length()), reference);
        }
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.checkName(sequence);
    }

    @Override
    public void visitSet(Set set) {
        this.checkName(set);
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer init) {
        int e = 0;
        while (e < init.getExpressionCount()) {
            init.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer init) {
        int e = 0;
        while (e < init.getExpressionCount()) {
            init.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
        comment.getExpr().accept(this);
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        call.getOperand().accept(this);
        int pCount = call.getParameterCount();
        int p = 0;
        while (p < pCount) {
            call.getParameter(p).accept(this);
            ++p;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
        if (this.context.includeLets()) {
            let.getVariable().accept(this);
        }
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        ifThen.getThenExpr().accept(this);
        ifThen.getElseExpr().accept(this);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        int dCount = call.getDeclaratorsCount();
        int d = 0;
        while (d < dCount) {
            call.getDeclarator(d).accept(this);
            ++d;
        }
        call.getExpression().accept(this);
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        if (expression.isLeaf()) {
            this.checkName(expression.getUnresolvedLeaf(), expression);
        } else {
            ConstraintSyntaxTree actual = expression.getActualExpression();
            if (actual != null) {
                actual.accept(this);
            }
        }
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        int v = 0;
        while (v < assignment.getElementCount()) {
            assignment.getElement(v).accept(this);
            ++v;
        }
        int c = 0;
        while (c < assignment.getConstraintsCount()) {
            assignment.getConstraint(c).accept(this);
            ++c;
        }
        int a = 0;
        while (a < assignment.getAssignmentCount()) {
            assignment.getAssignment(a).accept(this);
            ++a;
        }
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

