/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.values.BasisDatatypeValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class IntValue
extends BasisDatatypeValue {
    private Integer value;

    protected IntValue(String value) throws ValueDoesNotMatchTypeException {
        super(IntegerType.TYPE);
        this.setValue(value);
    }

    protected IntValue() {
        super(IntegerType.TYPE);
    }

    protected IntValue(Integer value) {
        super(IntegerType.TYPE);
        this.value = value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (value != null) {
            String sValue = this.stringValueOf(value);
            try {
                this.value = Integer.parseInt(sValue);
            }
            catch (NumberFormatException e) {
                throw new ValueDoesNotMatchTypeException(sValue, this, 10203);
            }
        } else {
            this.value = null;
        }
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitIntValue(this);
    }

    @Override
    public Value clone() {
        return new IntValue(this.value);
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof IntValue) {
            result = this.value.equals(((IntValue)object).getValue());
        }
        return result;
    }
}

