/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class MetaTypeValue
extends Value {
    private IDatatype value;

    protected MetaTypeValue(Object value) throws ValueDoesNotMatchTypeException {
        super(MetaType.TYPE);
        this.setValue(value);
    }

    protected MetaTypeValue() {
        super(MetaType.TYPE);
    }

    @Override
    public IDatatype getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (!(value instanceof IDatatype)) {
            throw new ValueDoesNotMatchTypeException(this.stringValueOf(value), this, 10205);
        }
        this.value = (IDatatype)value;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitMetaTypeValue(this);
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public Value clone() {
        MetaTypeValue result;
        try {
            result = new MetaTypeValue((Object)this.value);
        }
        catch (ValueDoesNotMatchTypeException e) {
            assert (false);
            result = null;
        }
        return result;
    }

    @Override
    public IDatatype getContainedType() {
        return this.value;
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value);
    }
}

