/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public final class NullValue
extends Value {
    public static final Value INSTANCE = new NullValue();
    public static final Object VALUE = new NullValueType();

    private NullValue() {
        super(AnyType.TYPE);
    }

    @Override
    public Object getValue() {
        return VALUE;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitNullValue(this);
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        throw new ValueDoesNotMatchTypeException("cannot assign a value to 'null' (constant)", 10206);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public Value clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return INSTANCE == other;
    }

    @Override
    public String toString() {
        return "NullValue";
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value);
    }

    public static class NullValueType {
        private NullValueType() {
        }
    }
}

