/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.validation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.model.IvmlKeyWords;
import net.ssehub.easy.varModel.model.datatypes.IVMLKeyWord;

public class IvmlIdentifierCheck {
    private static final Set<String> RESERVED = new HashSet<String>();

    static {
        IvmlIdentifierCheck.hash(IvmlKeyWords.class.getDeclaredFields(), false);
        IvmlIdentifierCheck.hash(IvmlKeyWords.class.getFields(), true);
    }

    private static final void hash(Field[] fields, boolean checkAnnotation) {
        int f = 0;
        while (f < fields.length) {
            Field field = fields[f];
            boolean add = !checkAnnotation || field.getAnnotation(IVMLKeyWord.class) != null;
            int mod = field.getModifiers();
            if (add && Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                try {
                    Object value = field.get(null);
                    if (value != null) {
                        RESERVED.add(value.toString());
                    }
                }
                catch (IllegalAccessException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(IvmlIdentifierCheck.class, "net.ssehub.easy.varModel");
                }
            }
            ++f;
        }
    }

    public static final boolean isValidIdentifier(String name) {
        return IvmlIdentifierCheck.isStructuralValidIdentifier(name) && !IvmlIdentifierCheck.isReservedName(name);
    }

    public static final boolean isStructuralValidIdentifier(String name) {
        boolean ok;
        if (name == null || name.length() == 0) {
            ok = false;
        } else {
            ok = true;
            int size = name.length();
            int i = 0;
            while (ok && i < size) {
                char ch = name.charAt(i);
                ok = i == 0 ? IvmlIdentifierCheck.isLetter(ch) || ch == '_' : IvmlIdentifierCheck.isLetter(ch) || Character.isDigit(ch) || ch == '_';
                ++i;
            }
        }
        return ok;
    }

    private static boolean isLetter(char character) {
        return 'a' <= character && character <= 'z' || 'A' <= character && character <= 'Z';
    }

    public static final boolean isReservedName(String name) {
        return name != null && RESERVED.contains(name);
    }
}

