/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DatatypeFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.VersionValue;
import net.ssehub.easy.varModel.validation.IvmlIdentifierCheck;
import net.ssehub.easy.varModel.validation.ValidationMessage;

public class IvmlValidationVisitor
extends AbstractVisitor
implements IValueVisitor,
IConstraintTreeVisitor {
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private Stack<String> location = new Stack();
    private java.util.Set<IDatatype> customTypes;

    public int getErrorCount() {
        int count = 0;
        int m = 0;
        while (m < this.messages.size()) {
            if (Status.ERROR == this.messages.get(m).getStatus()) {
                ++count;
            }
            ++m;
        }
        return count;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public ValidationMessage getMessage(int index) {
        return this.messages.get(index);
    }

    private void checkDeclaration(AbstractVariable decl) {
        IDatatype type = decl.getType();
        if ((type instanceof Enum || type instanceof Compound) && !this.customTypes.contains(type)) {
            this.addError("datatype '" + type.getName() + "' of '" + decl.getName() + "' is not part of the project", decl, 10808);
        }
    }

    private void checkNameIdentifier(String identifier, Object cause) {
        this.checkIdentifier(identifier, "name", cause, false);
    }

    private void checkIdentifier(String identifier, String info, Object cause, boolean allowWildcard) {
        String id = identifier;
        if (allowWildcard && id.endsWith("*")) {
            id = id.substring(0, id.length() - 1);
        }
        if (!IvmlIdentifierCheck.isValidIdentifier(id)) {
            if (info != null && ((String)info).length() > 0) {
                info = " at " + (String)info;
            }
            this.addError("invalid identifier '" + identifier + "'" + (String)info, cause, 10801);
        }
    }

    private void checkType(IDatatype type, Object cause) {
        if (type == null) {
            this.addError("type must not be <null>", cause, 10802);
        }
    }

    private void checkParent(IModelElement element, IModelElement expectedParent) {
        this.checkParent(element.getParent(), element, expectedParent);
    }

    private void checkParent(IModelElement parent, Object cause, IModelElement expectedParent) {
        if (parent == null) {
            this.addError("parent must not be <null> " + String.valueOf(cause.getClass()), cause, 10803);
        } else if (expectedParent != null && parent != expectedParent) {
            this.addError("incorrect reference to parent", cause, 10803);
        }
    }

    private void checkComment(String text, boolean allowNull, Object cause) {
        if (text != null) {
            if (text.indexOf("/*") >= 0 || text.indexOf("*/") >= 0) {
                this.addError("illegal comment '" + text + "'", cause, 10807);
            }
        } else if (!allowNull) {
            this.addError("comment is <null>'" + text + "'", cause, 10807);
        }
    }

    private boolean checkExpression(ConstraintSyntaxTree expression, String info, Object cause) {
        boolean isValid;
        boolean bl = isValid = expression != null;
        if (!isValid) {
            Object error = "expression is <null>";
            if (info != null && info.length() > 0) {
                error = info + " " + (String)error;
            }
            this.addError((String)error, cause, 10805);
        }
        return isValid;
    }

    private void addError(String text, Object cause, int code) {
        if (!this.location.isEmpty()) {
            text = (String)text + " in " + String.valueOf(this.location);
        }
        this.messages.add(new ValidationMessage((String)text, Status.ERROR, cause, code));
    }

    private void addElementIsNullError(String elementName, int pos, Object cause) {
        this.messages.add(new ValidationMessage(elementName + " " + pos + " must not be <null>", Status.ERROR, cause, 10800));
    }

    @Override
    public void visitProject(Project project) {
        this.checkNameIdentifier(project.getName(), project);
        this.location.push("project " + project.getName());
        int count = project.getImportsCount();
        int p = 0;
        while (p < count) {
            ProjectImport imp = project.getImport(p);
            if (imp == null) {
                this.addElementIsNullError("import", p, project);
            } else {
                imp.accept(this);
            }
            ++p;
        }
        if (1 == this.location.size()) {
            DatatypeFinder finder = new DatatypeFinder(project, FilterType.ALL, null);
            this.customTypes = new HashSet<CustomDatatype>(finder.getFoundDatatypes());
        }
        count = project.getElementCount();
        int c = 0;
        while (c < count) {
            ContainableModelElement elt = project.getElement(c);
            if (elt == null) {
                this.addElementIsNullError("element ", c, project);
            } else {
                this.checkParent(elt, project);
                elt.accept(this);
            }
            ++c;
        }
        this.location.pop();
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.checkNameIdentifier(eenum.getName(), eenum);
        this.location.push("enum " + eenum.getName());
        int count = eenum.getLiteralCount();
        int e = 0;
        while (e < count) {
            EnumLiteral lit = eenum.getLiteral(e);
            if (lit == null) {
                this.addElementIsNullError("literal", e, eenum);
            } else {
                this.checkParent(lit, eenum);
                lit.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.checkNameIdentifier(eenum.getName(), eenum);
        this.location.push("enum " + eenum.getName());
        int count = eenum.getLiteralCount();
        int e = 0;
        while (e < count) {
            EnumLiteral lit = eenum.getLiteral(e);
            if (lit == null) {
                this.addElementIsNullError("literal ", e, eenum);
            } else {
                this.checkParent(lit, eenum);
                lit.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitCompound(Compound compound) {
        this.checkNameIdentifier(compound.getName(), compound);
        this.location.push("compound " + compound.getName());
        int count = compound.getElementCount();
        int e = 0;
        while (e < count) {
            DecisionVariableDeclaration decl = compound.getElement(e);
            if (decl == null) {
                this.addElementIsNullError("declaration", e, compound);
            } else {
                this.checkParent(decl, compound);
                decl.accept(this);
            }
            ++e;
        }
        count = compound.getConstraintsCount();
        int c = 0;
        while (c < count) {
            Constraint constr = compound.getConstraint(c);
            if (constr == null) {
                this.addElementIsNullError("constraint", c, compound);
            } else {
                this.checkParent(constr, compound);
                constr.accept(this);
            }
            ++c;
        }
        count = compound.getAssignmentCount();
        c = 0;
        while (c < count) {
            AttributeAssignment assng = compound.getAssignment(c);
            if (assng == null) {
                this.addElementIsNullError("assignment", c, compound);
            } else {
                this.checkParent(assng, compound);
                assng.accept(this);
            }
            ++c;
        }
        this.location.pop();
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (pImport.getInterfaceName() != null) {
            this.checkIdentifier(pImport.getInterfaceName(), "interface", (Object)pImport, false);
        }
        this.checkIdentifier(pImport.getProjectName(), "project", (Object)pImport, pImport.isWildcard());
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        this.checkNameIdentifier(decl.getName(), decl);
        this.checkDeclaration(decl);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkNameIdentifier(attribute.getName(), attribute);
        this.checkDeclaration(attribute);
        IAttributableElement annotatedElement = attribute.getElement();
        if (annotatedElement != null) {
            boolean annotationFound;
            boolean bl = annotationFound = attribute == annotatedElement.getAttribute(attribute.getName());
            if (!annotationFound) {
                this.addError(annotatedElement.getClass().getSimpleName() + " \"" + annotatedElement.getName() + "\" was not annotated by " + attribute.getName(), annotatedElement, 10810);
            }
        } else {
            this.addError("Annotated element of " + attribute.getName() + " is <null>", attribute, 10800);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (constraint.getConsSyntax() != null) {
            constraint.getConsSyntax().accept(this);
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.location.push("freeze block");
        int f = 0;
        while (f < freeze.getFreezableCount()) {
            IFreezable freezable = freeze.getFreezable(f);
            if (freezable == null) {
                this.addElementIsNullError("freezable", f, freeze);
            } else if (!(freezable instanceof CompoundAccessStatement)) {
                this.checkIdentifier(freezable.getName(), "freezable " + f, freeze, false);
            }
            ++f;
        }
        this.location.pop();
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        this.checkNameIdentifier(opdef.getName(), opdef);
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.location.push("in partial evaluation block");
        int e = 0;
        while (e < block.getEvaluableCount()) {
            IPartialEvaluable eval = block.getEvaluable(e);
            if (eval == null) {
                this.addElementIsNullError("expression", e, block);
            } else {
                this.checkParent(eval.getParent(), eval, block);
                eval.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        this.checkNameIdentifier(iface.getName(), iface);
        this.location.push("interface " + iface.getName());
        int e = 0;
        while (e < iface.getExportsCount()) {
            DecisionVariableDeclaration decl = iface.getExport(e);
            if (decl == null) {
                this.addElementIsNullError("export", e, iface);
            } else {
                decl.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitComment(Comment comment) {
        this.checkComment(comment.getComment(), true, comment);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.location.push("attribute assignment");
        int e = 0;
        while (e < assignment.getConstraintsCount()) {
            Constraint constraint = assignment.getConstraint(e);
            if (constraint == null) {
                this.addElementIsNullError("constraint", e, assignment);
            } else {
                this.checkParent(constraint, assignment);
                constraint.accept(this);
            }
            ++e;
        }
        e = 0;
        while (e < assignment.getElementCount()) {
            DecisionVariableDeclaration decl = assignment.getElement(e);
            if (decl == null) {
                this.addElementIsNullError("declaration", e, assignment);
            } else {
                this.checkParent(decl, assignment);
                decl.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.checkNameIdentifier(datatype.getName(), datatype);
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
        this.checkNameIdentifier(literal.getName(), literal);
    }

    @Override
    public void visitReference(Reference reference) {
        this.checkType(reference.getType(), reference);
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.checkNameIdentifier(sequence.getName(), sequence);
    }

    @Override
    public void visitSet(Set set) {
        this.checkNameIdentifier(set.getName(), set);
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
        if (variable.getVariable() == null) {
            this.addError("link to variable declaration must not be <null>", variable, 10806);
        }
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        if (this.checkExpression(parenthesis.getExpr(), "parenthesis", parenthesis)) {
            parenthesis.getExpr().accept(this);
        }
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
        this.checkComment(comment.getComment(), true, comment);
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (call.getResolvedOperation() == null) {
            this.addError("Operation of OclFeatureCall could not be resolved.", call, 10809);
        }
        if (call.getOperand() != null) {
            call.getOperand().accept(this);
        }
        int i = 0;
        int n = call.getParameterCount();
        while (i < n) {
            call.getParameter(i).accept(this);
            ++i;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.location.push("compound initializer");
        this.checkType(initializer.getType(), initializer);
        int e = 0;
        while (e < initializer.getSlotCount()) {
            String name = initializer.getSlot(e);
            if (name == null) {
                this.addElementIsNullError("slot", e, initializer);
            } else if (initializer.getType().getElement(name) == null) {
                this.addError("slot '" + e + "' not declared in respective type", initializer, 10804);
            }
            ConstraintSyntaxTree cst = initializer.getExpression(e);
            if (cst == null) {
                this.addElementIsNullError("expression", e, initializer);
            } else {
                cst.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        this.location.push("container initializer");
        this.checkType(initializer.getType(), initializer);
        int e = 0;
        while (e < initializer.getExpressionCount()) {
            ConstraintSyntaxTree cst = initializer.getExpression(e);
            if (cst == null) {
                this.addElementIsNullError("expression", e, initializer);
            } else {
                cst.accept(this);
            }
            ++e;
        }
        this.location.pop();
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
    }

    @Override
    public void visitEnumValue(EnumValue value) {
    }

    @Override
    public void visitStringValue(StringValue value) {
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
    }

    @Override
    public void visitIntValue(IntValue value) {
    }

    @Override
    public void visitRealValue(RealValue value) {
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
    }

    @Override
    public void visitNullValue(NullValue value) {
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitVersionValue(VersionValue value) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

