/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.AllFreezeSelector;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.filter.AnnotationAssignmentFinder;
import net.ssehub.easy.varModel.model.filter.ConstraintFinder;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class AssignmentResolver {
    protected Configuration config;
    protected EvaluationVisitor evaluator;
    private int iterationLoops;
    private Map<IDatatype, List<IDecisionVariable>> instancesPerType;

    public AssignmentResolver(Configuration config) {
        this.config = config;
        this.evaluator = this.createEvaluationVisitor();
        this.iterationLoops = 5;
        this.instancesPerType = new HashMap<IDatatype, List<IDecisionVariable>>();
        for (IDecisionVariable variable : config) {
            IDatatype type = variable.getDeclaration().getType();
            List<IDecisionVariable> instances = this.instancesPerType.get(type);
            if (instances == null) {
                instances = new ArrayList<IDecisionVariable>();
                this.instancesPerType.put(type, instances);
            }
            instances.add(variable);
            this.findInstancesOfNestedVariavbles(variable);
        }
    }

    private void findInstancesOfNestedVariavbles(IDecisionVariable variable) {
        int i = 0;
        int n = variable.getNestedElementsCount();
        while (i < n) {
            IDecisionVariable nestedVar = variable.getNestedElement(i);
            IDatatype type = nestedVar.getDeclaration().getType();
            List<IDecisionVariable> instances = this.instancesPerType.get(type);
            if (instances == null) {
                instances = new ArrayList<IDecisionVariable>();
                this.instancesPerType.put(type, instances);
            }
            instances.add(nestedVar);
            this.findInstancesOfNestedVariavbles(nestedVar);
            ++i;
        }
    }

    protected List<IDecisionVariable> getInstancesForType(IDatatype type) {
        return this.instancesPerType.get(type);
    }

    protected EvaluationVisitor createEvaluationVisitor() {
        return new EvaluationVisitor();
    }

    public void resolve() {
        ArrayList<Project> projects = new ArrayList<Project>();
        this.findImportedProjects(projects);
        int p = 0;
        while (p < projects.size()) {
            Project project = (Project)projects.get(p);
            this.evaluator.setDispatchScope(project);
            this.resolveDefaultValues(project);
            this.resolveAnnotationAssignments(project);
            this.resolveAssignments(project);
            ++p;
        }
    }

    private void resolveAnnotationAssignments(Project project) {
        AnnotationAssignmentFinder finder = new AnnotationAssignmentFinder(project, FilterType.NO_IMPORTS, false);
        List<AttributeAssignment> assignmentBlocks = finder.getAssignmentBlocks();
        int i = 0;
        int n = assignmentBlocks.size();
        while (i < n) {
            AttributeAssignment assignBlock = assignmentBlocks.get(i);
            HashMap<String, Value> annotationAssignments = new HashMap<String, Value>();
            IModelElement parent = assignBlock.getParent();
            List<IDecisionVariable> parents = null;
            if (parent instanceof Project) {
                parents = new ArrayList<IDecisionVariable>();
            } else if (parent instanceof IDatatype) {
                parents = this.instancesPerType.get((IDatatype)((Object)parent));
            }
            this.resolveAnnotationAssignments(assignBlock, annotationAssignments, parents);
            ++i;
        }
    }

    private void resolveAnnotationAssignments(AttributeAssignment assignBlock, Map<String, Value> annotationAssignments, List<IDecisionVariable> parents) {
        int i = 0;
        int n = assignBlock.getAssignmentDataCount();
        while (i < n) {
            AttributeAssignment.Assignment assignment = assignBlock.getAssignmentData(i);
            String annotationName = assignment.getName();
            ConstraintSyntaxTree constraint = assignment.getExpression();
            this.evaluator.init(this.config, AssignmentState.DEFAULT, false, null);
            this.evaluator.visit(constraint);
            Value value = this.evaluator.getResult();
            if (value != null) {
                annotationAssignments.put(annotationName, value);
            }
            this.evaluator.clear();
            ++i;
        }
        i = 0;
        n = assignBlock.getElementCount();
        while (i < n) {
            assignBlock.getElement(i).accept(new AssignBlockVisitor(annotationAssignments, parents));
            ++i;
        }
    }

    protected void resolveDefaultValues(Project project) {
        DeclarationFinder finder = new DeclarationFinder(project, FilterType.NO_IMPORTS, null);
        List<AbstractVariable> variables = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ALL);
        boolean variablesResolved = true;
        int remainingSteps = this.iterationLoops > 0 ? this.iterationLoops : 1;
        while (variables.size() > 0 && variablesResolved && remainingSteps > 0) {
            ArrayList<AbstractVariable> unresolvedVariables = new ArrayList<AbstractVariable>();
            variablesResolved = false;
            for (AbstractVariable decl : variables) {
                if (this.resolveDefaultValueForDeclaration(decl, this.config.getDecision(decl))) continue;
                unresolvedVariables.add(decl);
                variablesResolved = true;
            }
            variables = unresolvedVariables;
            unresolvedVariables = new ArrayList();
            --remainingSteps;
        }
    }

    public static boolean resolveDefaultValue(IDecisionVariable variable, EvaluationVisitor evaluator) {
        return AssignmentResolver.resolveDefaultValueForDeclaration(variable.getDeclaration(), variable, evaluator != null ? evaluator : new EvaluationVisitor(), variable.getConfiguration(), null);
    }

    public static boolean resolveDefaultValue(IDecisionVariable variable) {
        return AssignmentResolver.resolveDefaultValue(variable, null);
    }

    protected static boolean resolveDefaultValueForDeclaration(AbstractVariable decl, IDecisionVariable variable, EvaluationVisitor evaluator, IConfiguration config, AssignmentResolver conflictHandler) {
        ConstraintSyntaxTree defaultValue;
        boolean valueResolved = false;
        IDatatype type = decl.getType();
        if (Compound.TYPE.isAssignableFrom(type) && variable != null) {
            Compound cmpType = (Compound)type;
            CompoundVariable cmpVar = (CompoundVariable)variable;
            int i = 0;
            int n = cmpType.getInheritedElementCount();
            while (i < n) {
                DecisionVariableDeclaration nestedDecl = cmpType.getInheritedElement(i);
                AssignmentResolver.resolveDefaultValueForDeclaration(nestedDecl, cmpVar.getNestedVariable(nestedDecl.getName()), evaluator, config, conflictHandler);
                ++i;
            }
        }
        if ((defaultValue = decl.getDefaultValue()) != null && variable != null) {
            if (type == ConstraintType.TYPE) {
                try {
                    value = ValueFactory.createValue(type, defaultValue);
                    variable.setValue(value, AssignmentState.DEFAULT);
                }
                catch (ConfigurationException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(AssignmentResolver.class, "net.ssehub.easy.varModel").exception((Exception)e);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(AssignmentResolver.class, "net.ssehub.easy.varModel").exception((Exception)e);
                }
            } else {
                evaluator.init(config, AssignmentState.DEFAULT, false, null);
                evaluator.visit(defaultValue);
                if (evaluator.constraintFailed() && !BooleanType.TYPE.isAssignableFrom(type)) {
                    if (conflictHandler != null) {
                        conflictHandler.conflictingDefault(decl);
                    }
                    evaluator.clear();
                } else {
                    value = evaluator.getResult();
                    evaluator.clear();
                    if (value != null) {
                        value = AssignmentResolver.augmentValue(value, variable, evaluator, config, conflictHandler);
                        try {
                            variable.setValue(value, AssignmentState.DEFAULT);
                            valueResolved = true;
                        }
                        catch (ConfigurationException e) {
                            EASyLoggerFactory.INSTANCE.getLogger(AssignmentResolver.class, "net.ssehub.easy.varModel").exception((Exception)e);
                        }
                    }
                }
            }
            if (decl.isConstant()) {
                variable.freeze(AllFreezeSelector.INSTANCE);
            }
        }
        return valueResolved;
    }

    private static Value augmentValue(Value value, IDecisionVariable variable, EvaluationVisitor evaluator, IConfiguration config, AssignmentResolver conflictHandler) {
        if (value instanceof CompoundValue && !TypeQueries.sameTypes(value.getType(), variable.getDeclaration().getType())) {
            HashMap<String, Value> values = new HashMap<String, Value>();
            CompoundValue cValue = (CompoundValue)value;
            for (String slot : cValue.getSlotNames()) {
                values.put(slot, cValue.getNestedValue(slot));
            }
            Compound cType = (Compound)value.getType();
            int e = 0;
            while (e < cType.getElementCount()) {
                DecisionVariableDeclaration slotDecl = cType.getElement(e);
                if (values.get(slotDecl.getName()) == null) {
                    IDecisionVariable slotVar = variable.getNestedElement(slotDecl.getName());
                    if (slotVar.getValue() == null) {
                        AssignmentResolver.resolveDefaultValueForDeclaration(slotVar.getDeclaration(), slotVar, evaluator, config, conflictHandler);
                    }
                    if (slotVar != null && slotVar.getValue() != null) {
                        values.put(slotDecl.getName(), slotVar.getValue());
                    }
                }
                ++e;
            }
            Object[] tmp = new Object[values.size() * 2];
            int pos = 0;
            for (Map.Entry ent : values.entrySet()) {
                tmp[pos++] = ent.getKey();
                tmp[pos++] = ent.getValue();
            }
            try {
                value = ValueFactory.createValue(value.getType(), tmp);
            }
            catch (ValueDoesNotMatchTypeException e2) {
                EASyLoggerFactory.INSTANCE.getLogger(AssignmentResolver.class, null).exception((Exception)e2);
            }
        }
        return value;
    }

    protected boolean resolveDefaultValueForDeclaration(AbstractVariable decl, IDecisionVariable variable) {
        return AssignmentResolver.resolveDefaultValueForDeclaration(decl, variable, this.evaluator, this.config, this);
    }

    protected void resolveAssignments(Project project) {
        ArrayList<Constraint> unresolvedConstraints = new ArrayList<Constraint>();
        ConstraintFinder finder = new ConstraintFinder(project, false);
        List<Constraint> constraints = finder.getConstraints();
        int nConstraintsInLastIteration = constraints.size();
        int remainingSteps = this.iterationLoops > 0 ? this.iterationLoops : 1;
        while (!constraints.isEmpty() && remainingSteps > 0) {
            for (Constraint constraint : constraints) {
                ConstraintSyntaxTree cst = constraint.getConsSyntax();
                if (cst == null) continue;
                this.evaluator.init(this.config, this.config.getResolutionState(), false, null);
                this.evaluator.visit(cst);
                if (this.evaluator.getResult() == null) {
                    unresolvedConstraints.add(constraint);
                } else if (this.evaluator.constraintFailed()) {
                    this.conflictingConstraint(constraint);
                }
                this.evaluator.clear();
            }
            int openConstraints = unresolvedConstraints.size();
            if (nConstraintsInLastIteration != openConstraints) {
                constraints = unresolvedConstraints;
                unresolvedConstraints = new ArrayList();
                nConstraintsInLastIteration = openConstraints;
                if (this.iterationLoops <= 0) continue;
                --remainingSteps;
                continue;
            }
            constraints.clear();
        }
    }

    protected void conflictingConstraint(Constraint constraint) {
    }

    protected void conflictingDefault(AbstractVariable decl) {
    }

    private void findImportedProjects(List<Project> projects) {
        this.findImportedProjects(this.config.getProject(), projects, new HashSet<Project>());
    }

    private void findImportedProjects(Project project, List<Project> projects, java.util.Set<Project> done) {
        if (!done.contains(project)) {
            Project importedProject;
            done.add(project);
            int minPos = -1;
            int i = 0;
            int n = project.getImportsCount();
            while (i < n) {
                importedProject = (Project)project.getImport(i).getResolved();
                if (importedProject != null) {
                    this.findImportedProjects(importedProject, projects, done);
                }
                ++i;
            }
            i = 0;
            n = project.getImportsCount();
            while (i < n) {
                importedProject = (Project)project.getImport(i).getResolved();
                if (importedProject != null) {
                    minPos = Math.max(minPos, projects.indexOf(importedProject));
                }
                ++i;
            }
            projects.add(minPos + 1, project);
        }
    }

    private class AssignBlockVisitor
    implements IModelVisitor {
        private Map<String, Value> annotationAssignments;
        private List<IDecisionVariable> parents;
        private boolean visitNestedElements;

        private AssignBlockVisitor(Map<String, Value> annotationAssignments, List<IDecisionVariable> parents) {
            this.annotationAssignments = annotationAssignments;
            this.parents = parents;
            this.visitNestedElements = parents != null && !parents.isEmpty();
        }

        @Override
        public void visitSet(Set set) {
        }

        @Override
        public void visitSequence(Sequence sequence) {
        }

        @Override
        public void visitReference(Reference reference) {
        }

        @Override
        public void visitOrderedEnum(OrderedEnum eenum) {
        }

        @Override
        public void visitEnumLiteral(EnumLiteral literal) {
        }

        @Override
        public void visitEnum(Enum eenum) {
        }

        @Override
        public void visitDerivedDatatype(DerivedDatatype datatype) {
        }

        @Override
        public void visitCompound(Compound compound) {
            List<IDecisionVariable> oldParents = this.parents;
            boolean oldVisitState = this.visitNestedElements;
            this.visitNestedElements = true;
            this.parents = AssignmentResolver.this.getInstancesForType(compound);
            compound.accept(this);
            this.visitNestedElements = oldVisitState;
            this.parents = oldParents;
        }

        @Override
        public void visitProjectInterface(ProjectInterface iface) {
        }

        @Override
        public void visitProjectImport(ProjectImport pImport) {
        }

        @Override
        public void visitProject(Project project) {
        }

        @Override
        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        }

        @Override
        public void visitOperationDefinition(OperationDefinition opdef) {
        }

        @Override
        public void visitFreezeBlock(FreezeBlock freeze) {
        }

        @Override
        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            if (!this.visitNestedElements) {
                IDecisionVariable variable = AssignmentResolver.this.config.getDecision(decl);
                this.assignAnnotationValuesToVariable(variable);
            } else {
                int i = 0;
                int n = this.parents.size();
                while (i < n) {
                    IDecisionVariable parentVar = this.parents.get(i);
                    int j = 0;
                    int m = parentVar.getNestedElementsCount();
                    while (j < m) {
                        IDecisionVariable nestedVar = parentVar.getNestedElement(j);
                        if (decl == nestedVar.getDeclaration()) {
                            this.assignAnnotationValuesToVariable(nestedVar);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }

        private void assignAnnotationValuesToVariable(IDecisionVariable variable) {
            if (variable != null) {
                int i = 0;
                int n = variable.getAttributesCount();
                while (i < n) {
                    IDecisionVariable annotation = variable.getAttribute(i);
                    Value annotationValue = this.annotationAssignments.get(annotation.getDeclaration().getName());
                    if (annotationValue != null) {
                        try {
                            annotation.setValue(annotationValue, AssignmentState.ASSIGNED);
                        }
                        catch (ConfigurationException e) {
                            Bundle.getLogger(AssignmentResolver.class).exception((Exception)e);
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public void visitConstraint(Constraint constraint) {
        }

        @Override
        public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        }

        @Override
        public void visitComment(Comment comment) {
        }

        @Override
        public void visitAttributeAssignment(AttributeAssignment assignment) {
            HashMap<String, Value> nestedAssignments = new HashMap<String, Value>();
            nestedAssignments.putAll(this.annotationAssignments);
            AssignmentResolver.this.resolveAnnotationAssignments(assignment, nestedAssignments, this.parents);
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }
    }
}

