/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public class ConstantAccessor
extends EvaluationAccessor {
    public static final Pool<ConstantAccessor> POOL = new Pool((IPoolManager)new IPoolManager<ConstantAccessor>(){

        public ConstantAccessor create() {
            return new ConstantAccessor();
        }

        public void clear(ConstantAccessor instance) {
            instance.clear();
        }
    });
    private Value value;
    private boolean isConstant;

    private ConstantAccessor() {
    }

    public ConstantAccessor bind(Value value, boolean isConstant, EvaluationContext context) {
        super.bind(context);
        this.value = value;
        this.isConstant = isConstant;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.value = null;
        this.isConstant = false;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Value value, boolean asAssignment) {
        Object valueMsg = "null";
        if (value != null) {
            valueMsg = String.valueOf(value.getValue()) + "/" + IvmlDatatypeVisitor.getUnqualifiedType(value.getType());
        }
        this.getContext().addErrorMessage("cannot assign value " + (String)valueMsg + " to a constant", 102);
        return false;
    }

    @Override
    public boolean isAssignable() {
        return false;
    }

    @Override
    public void release() {
        POOL.releaseInstance((Object)this);
    }

    @Override
    public IDecisionVariable getVariable() {
        return null;
    }

    @Override
    public EvaluationAccessor getValue(EvaluationAccessor accessor) {
        ConstantAccessor result = null;
        if (this.value instanceof ContainerValue) {
            Value aValue = accessor.getValue();
            if (aValue instanceof IntValue) {
                ContainerValue cVal = (ContainerValue)this.value;
                int index = OclKeyWords.toJavaIndex(((IntValue)aValue).getValue());
                if (index >= 0 && index < cVal.getElementSize()) {
                    result = ((ConstantAccessor)POOL.getInstance()).bind(cVal.getElement(index), false, this.getContext());
                } else {
                    this.getContext().addErrorMessage("invalid index value " + index, 102);
                }
            } else {
                this.getContext().addErrorMessage("index must be an integer value", 102);
            }
        } else {
            this.getContext().addErrorMessage("left side of accessor must be a compound value", 102);
        }
        return result;
    }

    @Override
    public Value getReferenceValue() {
        Value result = this.value instanceof ReferenceValue ? this.value : null;
        return result;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }
}

