/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ValidationVisitor;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.VoidType;

public class Constraint
extends ContainableModelElement
implements IPartialEvaluable {
    private ConstraintSyntaxTree consSyntax;

    Constraint() {
        this((IModelElement)null);
    }

    public Constraint(IModelElement parent) {
        super("", parent);
    }

    public Constraint(String name, IModelElement parent) {
        super(name, parent);
    }

    public Constraint(ConstraintSyntaxTree consSyntax, IModelElement parent) throws CSTSemanticException {
        this("", consSyntax, parent);
    }

    public Constraint(String name, ConstraintSyntaxTree consSyntax, IModelElement parent) throws CSTSemanticException {
        super(name, parent);
        this.setConsSyntax(consSyntax);
    }

    public ConstraintSyntaxTree getConsSyntax() {
        return this.consSyntax;
    }

    public void setConsSyntax(ConstraintSyntaxTree consSyntax) throws CSTSemanticException {
        String error;
        if (consSyntax != null && (error = Constraint.check(consSyntax)) != null) {
            throw new CSTSemanticException(error, 10100);
        }
        this.consSyntax = consSyntax;
    }

    private static String check(ConstraintSyntaxTree cst) throws CSTSemanticException {
        IDatatype type = cst.inferDatatype();
        String error = null;
        ValidationVisitor vis = new ValidationVisitor();
        cst.accept(vis);
        if (VoidType.TYPE == type) {
            if (vis.isAssignment()) {
                if (!vis.isValidAssignment()) {
                    error = "assignment is not valid";
                }
            } else {
                error = "constraints must be of type boolean";
            }
        } else {
            error = BooleanType.TYPE.isAssignableFrom(type) || ConstraintType.TYPE.isAssignableFrom(type) ? null : "constraints must be either an assignment or of type boolean";
        }
        if (vis.getErrorCount() > 0) {
            error = vis.getErrorString();
        }
        return error;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitConstraint(this);
    }

    public boolean isBooleanConstraint() {
        boolean isBoolean = false;
        if (this.consSyntax != null) {
            try {
                isBoolean = BooleanType.TYPE.isAssignableFrom(this.consSyntax.inferDatatype());
            }
            catch (CSTSemanticException cSTSemanticException) {
                // empty catch block
            }
        }
        return isBoolean;
    }

    @Override
    public String toString() {
        return "constraint (type: " + String.valueOf(this.getType()) + ") = " + (this.getConsSyntax() == null ? null : this.getConsSyntax().toString());
    }

    public IConstraintType getType() {
        return Type.USUAL;
    }

    public Object getAttachedTo() {
        return null;
    }

    public Constraint createConstraint(ConstraintSyntaxTree consSyntax) throws CSTSemanticException {
        return new Constraint(consSyntax, this.getParent());
    }

    public static interface IConstraintType {
    }

    public static enum Type implements IConstraintType
    {
        USUAL,
        DEFAULT,
        CONSTRAINT,
        ANNOTATION_ASSIGNMENT;

    }
}

