/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BasisDatatype;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class ConstraintType
extends BasisDatatype {
    public static final IDatatype TYPE = AnyType.CONSTRAINT_TYPE;
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, BooleanType.TYPE);
    public static final Operation UNEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, BooleanType.TYPE);
    public static final Operation UNEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, BooleanType.TYPE);
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, BooleanType.TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation IF_DEFINED = new Operation(BooleanType.TYPE, "ifDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();

    static {
        AnyType.CONSTRAINT_TYPE.setDelegate(new ConstraintType());
        AnyType.CONSTRAINT_TYPE.addOperation(EQUALS);
        AnyType.CONSTRAINT_TYPE.addOperation(UNEQUALS);
        AnyType.CONSTRAINT_TYPE.addOperation(UNEQUALS_ALIAS);
        AnyType.CONSTRAINT_TYPE.addOperation(ASSIGNMENT);
        AnyType.CONSTRAINT_TYPE.addOperation(IS_DEFINED);
        AnyType.CONSTRAINT_TYPE.addOperation(IF_DEFINED);
        AnyType.CONSTRAINT_TYPE.addOperation(TYPE_OF);
    }

    private ConstraintType() {
        super("Constraint", AnyType.CONSTRAINT_TYPE);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitConstraintType(this);
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        return super.isAssignableFrom(type) || BooleanType.TYPE.equals(type);
    }

    public static boolean isConstraint(IDatatype type) {
        return type == TYPE || type instanceof ConstraintType;
    }
}

