/*
 * Copyright 2009-2013 University of Hildesheim, Software Systems Engineering
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ssehub.easy.varModel.persistency;

/**
 * Constants for saving/loading variability model files.
 * @author El-Sharkawy
 *
 */
public class PersistencyConstants {

    /**
     * Default file extension for project files.
     */
    public static final String PROJECT_FILE_EXTENSION = "ivml";
    
    /**
     * Default file extension for comment files.
     */
    public static final String COMMENT_FILE_EXTENSION = "text";
    
    /**
     * Default file ending for project files.
     */
    public static final String PROJECT_FILE_ENDING = "." + PROJECT_FILE_EXTENSION;
    
    /**
     * Default file ending for project files.
     */
    public static final String COMMENT_FILE_ENDING = "." + COMMENT_FILE_EXTENSION;
}
