/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;

public class BasicCopyVisitor
implements IConstraintTreeVisitor {
    private ConstraintSyntaxTree result;
    private boolean copyVariables = false;
    private boolean doInferDatatype = false;
    private boolean copyConstants = true;
    private boolean copyExpressions = true;

    protected BasicCopyVisitor() {
    }

    protected void setCopyVariables(boolean copyVariables) {
        this.copyVariables = copyVariables;
    }

    protected boolean getCopyVariables() {
        return this.copyVariables;
    }

    protected void setDoInferDatatype(boolean doInferDatatype) {
        this.doInferDatatype = doInferDatatype;
    }

    protected void setCopyConstants(boolean copyConstants) {
        this.copyConstants = copyConstants;
    }

    protected void setCopyExpressions(boolean copyExpressions) {
        this.copyExpressions = copyExpressions;
    }

    protected boolean getCopyExpressions() {
        return this.copyExpressions;
    }

    protected void setResult(ConstraintSyntaxTree cst) {
        this.result = cst;
    }

    public ConstraintSyntaxTree getResult() {
        return this.result;
    }

    public void clear() {
        this.result = null;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        this.result = this.copyConstants ? new ConstantValue(value.getConstantValue()) : value;
    }

    @Override
    public void visitVariable(Variable variable) {
        this.result = this.copyVariables ? new Variable(variable.getVariable()) : variable;
    }

    protected DecisionVariableDeclaration mapVariable(DecisionVariableDeclaration var) {
        return var;
    }

    protected AbstractVariable mapVariable(AbstractVariable var) {
        return var;
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        ConstraintSyntaxTree parEx = parenthesis.getExpr();
        parEx.accept(this);
        this.result = this.copyExpressions || parEx != this.result ? this.inferDatatype(new Parenthesis(this.result)) : parenthesis;
    }

    @Override
    public void visitComment(Comment comment) {
        ConstraintSyntaxTree cEx = comment.getExpr();
        cEx.accept(this);
        this.result = this.copyExpressions || cEx != this.result ? new Comment(this.result, comment.getComment()) : comment;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        boolean doCopy = this.copyExpressions;
        ConstraintSyntaxTree operand = call.getOperand();
        if (operand != null) {
            operand.accept(this);
            doCopy |= operand != this.result;
            operand = this.result;
        }
        ConstraintSyntaxTree[] args = new ConstraintSyntaxTree[call.getParameterCount()];
        int p = 0;
        while (p < args.length) {
            ConstraintSyntaxTree arg = call.getParameter(p);
            arg.accept(this);
            doCopy |= arg != this.result;
            args[p] = this.result;
            ++p;
        }
        if (doCopy) {
            OCLFeatureCall ofc = new OCLFeatureCall(operand, call.getOperation(), call.getAccessor(), args);
            this.result = this.inferDatatype(ofc);
            if (ofc.getResolvedOperation() == null) {
                ofc.setResolvedOperation(call.getResolvedOperation());
            }
        } else {
            this.result = call;
        }
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        boolean doCopy = this.copyExpressions;
        OCLFeatureCall[] expressions = new OCLFeatureCall[expression.getExpressionCount()];
        int e = 0;
        while (e < expressions.length) {
            OCLFeatureCall ex = expression.getExpression(e);
            ((ConstraintSyntaxTree)ex).accept(this);
            doCopy |= ex != this.result;
            expressions[e] = (OCLFeatureCall)this.result;
            ++e;
        }
        if (doCopy) {
            try {
                this.result = this.inferDatatype(new MultiAndExpression(expressions));
            }
            catch (CSTSemanticException e2) {
                this.getLogger().exception((Exception)e2);
            }
        } else {
            this.result = expression;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
        this.result = this.inferDatatype(new DeferInitExpression(this.result));
    }

    @Override
    public void visitLet(Let let) {
        DecisionVariableDeclaration letVar = let.getVariable();
        DecisionVariableDeclaration var = this.mapVariable(letVar);
        ConstraintSyntaxTree ex = let.getInExpression();
        ex.accept(this);
        this.result = this.copyExpressions || letVar != var || ex != this.result ? this.inferDatatype(new Let(var, this.result)) : let;
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ConstraintSyntaxTree elseExpr;
        ConstraintSyntaxTree ifE = ifThen.getIfExpr();
        ifE.accept(this);
        ConstraintSyntaxTree ifExpr = this.result;
        ConstraintSyntaxTree thenE = ifThen.getThenExpr();
        thenE.accept(this);
        ConstraintSyntaxTree thenExpr = this.result;
        ConstraintSyntaxTree elseE = ifThen.getElseExpr();
        if (elseE != null) {
            elseE.accept(this);
            elseExpr = this.result;
        } else {
            elseExpr = null;
        }
        this.result = this.copyExpressions || ifE != ifExpr || thenE != thenExpr || elseE != elseExpr ? this.inferDatatype(new IfThen(ifExpr, thenExpr, elseExpr)) : ifThen;
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        ConstraintSyntaxTree cCont = call.getContainer();
        cCont.accept(this);
        ConstraintSyntaxTree container = this.result;
        ConstraintSyntaxTree cEx = call.getExpression();
        cEx.accept(this);
        ConstraintSyntaxTree expression = this.result;
        boolean doCopy = this.copyExpressions || cCont != container || cEx != expression;
        DecisionVariableDeclaration[] decls = new DecisionVariableDeclaration[call.getDeclaratorsCount()];
        int d = 0;
        while (d < decls.length) {
            DecisionVariableDeclaration decl = call.getDeclarator(d);
            decls[d] = this.mapVariable(decl);
            doCopy |= decls[d] != decl;
            ++d;
        }
        this.result = doCopy ? this.inferDatatype(new ContainerOperationCall(container, call.getOperation(), expression, decls)) : call;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        ConstraintSyntaxTree cEx = access.getCompoundExpression();
        cEx.accept(this);
        this.result = this.copyExpressions || cEx != this.result ? this.inferDatatype(new CompoundAccess(this.result, access.getSlotName())) : access;
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        String leaf = expression.getUnresolvedLeaf();
        if (leaf != null) {
            this.result = this.copyExpressions ? new UnresolvedExpression(expression.getUnresolvedLeaf()) : expression;
        } else {
            ConstraintSyntaxTree ex = expression.getActualExpression();
            if (ex != null) {
                ex.accept(this);
            } else {
                this.result = null;
            }
            this.result = this.copyExpressions || this.result != ex ? new UnresolvedExpression(this.result) : expression;
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        boolean doCopy = this.copyExpressions;
        AbstractVariable[] slotDecls = new DecisionVariableDeclaration[initializer.getSlotCount()];
        int s = 0;
        while (s < slotDecls.length) {
            AbstractVariable decl = initializer.getSlotDeclaration(s);
            slotDecls[s] = this.mapVariable(decl);
            doCopy |= slotDecls[s] != decl;
            ++s;
        }
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
        int e = 0;
        while (e < exprs.length) {
            ConstraintSyntaxTree ex = initializer.getExpression(e);
            ex.accept(this);
            doCopy |= this.result != ex;
            exprs[e] = this.result;
            ++e;
        }
        if (doCopy) {
            try {
                String[] slots = new String[initializer.getSlotCount()];
                int s2 = 0;
                while (s2 < slots.length) {
                    slots[s2] = initializer.getSlot(s2);
                    ++s2;
                }
                this.result = this.inferDatatype(new CompoundInitializer(initializer.getType(), slots, slotDecls, exprs));
            }
            catch (CSTSemanticException e2) {
                this.getLogger().exception((Exception)e2);
            }
        } else {
            this.result = initializer;
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        boolean doCopy = this.copyExpressions;
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
        int e = 0;
        while (e < exprs.length) {
            ConstraintSyntaxTree ex = initializer.getExpression(e);
            ex.accept(this);
            doCopy |= ex != this.result;
            exprs[e] = this.result;
            ++e;
        }
        if (doCopy) {
            try {
                this.result = this.inferDatatype(new ContainerInitializer(initializer.getType(), exprs));
            }
            catch (CSTSemanticException e2) {
                this.getLogger().exception((Exception)e2);
            }
        } else {
            this.result = initializer;
        }
    }

    @Override
    public void visitSelf(Self self) {
        this.result = self;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qualifier;
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (qu != null) {
            qu.accept(this);
            qualifier = this.result;
        } else {
            qualifier = null;
        }
        AbstractVariable var = variable.getVariable();
        Attribute mVar = (Attribute)this.mapVariable(var);
        this.result = this.copyExpressions || qu != qualifier || var != mVar ? new AttributeVariable(qualifier, mVar) : variable;
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        boolean doCopy = this.copyExpressions;
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[block.getExpressionCount()];
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            ConstraintSyntaxTree ex = block.getExpression(e);
            ex.accept(this);
            doCopy |= ex != this.result;
            exprs[e] = this.result;
            ++e;
        }
        if (doCopy) {
            try {
                this.result = new BlockExpression(exprs);
            }
            catch (CSTSemanticException e2) {
                this.getLogger().exception((Exception)e2);
            }
        } else {
            this.result = block;
        }
    }

    protected ConstraintSyntaxTree inferDatatype(ConstraintSyntaxTree cst) {
        if (this.doInferDatatype) {
            try {
                cst.inferDatatype();
            }
            catch (CSTSemanticException e) {
                this.getLogger().exception((Exception)e);
            }
        }
        return cst;
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
    }
}

