/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.Stack;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.ConfigurationInitializerRegistry;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cstEvaluation.CompoundSlotAccessor;
import net.ssehub.easy.varModel.cstEvaluation.ContainerElementAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.VariableAccessor;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.values.Value;

class ContextStack {
    private static final Pool<StackFrame> POOL = new Pool((IPoolManager)new IPoolManager<StackFrame>(){

        public StackFrame create() {
            return new StackFrame();
        }

        public void clear(StackFrame instance) {
            instance.ex = null;
            instance.self = null;
            instance.init = null;
            instance.index = -1;
            instance.slot = null;
        }
    });
    private Stack<StackFrame> stack = new Stack();
    private int currentStart = -1;

    ContextStack() {
    }

    void push(EvaluationAccessor ex) {
        StackFrame frame = (StackFrame)POOL.getInstance();
        frame.ex = ex;
        this.stack.push(frame);
        if (frame != null) {
            this.currentStart = this.stack.size() - 1;
        }
    }

    void push() {
        this.stack.push((StackFrame)POOL.getInstance());
    }

    void push(ContainerInitializer init) {
        this.push();
        this.setContainerInitializer(init);
    }

    void setVariable(DecisionVariableDeclaration var) {
        StackFrame frame = this.stack.peek();
        frame.var = var;
        frame.self = null;
    }

    void setContainerInitializer(ContainerInitializer init) {
        StackFrame frame = this.stack.peek();
        frame.init = init;
        frame.self = null;
    }

    void setContainerIndex(int index) {
        StackFrame frame = this.stack.peek();
        frame.index = index;
        frame.self = null;
    }

    void setCompoundSlot(String slot) {
        StackFrame frame = this.stack.peek();
        frame.slot = slot;
        frame.self = null;
    }

    void pop() {
        StackFrame frame = this.stack.pop();
        if (frame.ex != null) {
            this.currentStart = this.stack.size() - 1;
            while (this.currentStart >= 0 && ((StackFrame)this.stack.get((int)this.currentStart)).ex == null) {
                --this.currentStart;
            }
        }
        POOL.releaseInstance((Object)frame);
    }

    void clear() {
        while (!this.stack.isEmpty()) {
            this.pop();
        }
        this.currentStart = -1;
    }

    Value getSelfValue() {
        Value result = null;
        if (this.currentStart >= 0) {
            StackFrame top = this.stack.peek();
            result = top.self;
            if (result == null) {
                EvaluationAccessor ex;
                EvaluationAccessor seed = ex = ((StackFrame)this.stack.get((int)this.currentStart)).ex;
                int pos = this.currentStart + 1;
                int n = this.stack.size() - 1;
                while (pos < n) {
                    StackFrame frame = (StackFrame)this.stack.get(pos);
                    EvaluationAccessor old = ex;
                    IDecisionVariable var = ex.getVariable();
                    if (frame.index >= 0) {
                        this.ensureCapacity(var, frame);
                        ex = ((ContainerElementAccessor)ContainerElementAccessor.POOL.getInstance()).bind(var, frame.index, ex.getContext());
                    } else if (frame.slot != null) {
                        ex = ((CompoundSlotAccessor)CompoundSlotAccessor.POOL.getInstance()).bind(var, frame.slot, ex.getContext());
                    } else if (frame.var != null) {
                        ex = ((VariableAccessor)VariableAccessor.POOL.getInstance()).bind(frame.var, ex.getContext());
                    }
                    if (old != seed) {
                        old.release();
                    }
                    ++pos;
                }
                top.self = result = ex.getValue();
                if (ex != seed) {
                    ex.release();
                }
            }
        }
        return result;
    }

    private void ensureCapacity(IDecisionVariable var, StackFrame frame) {
        int index = frame.index;
        ContainerInitializer init = frame.init;
        if (var.getNestedElementsCount() <= index && var instanceof ContainerVariable) {
            ContainerVariable cVar = (ContainerVariable)var;
            while (cVar.getNestedElementsCount() <= index) {
                IDecisionVariable element = null;
                if (init != null) {
                    ConstraintSyntaxTree initEx = init.getExpression(cVar.getNestedElementsCount());
                    try {
                        element = cVar.addNestedElement(initEx.inferDatatype());
                    }
                    catch (CSTSemanticException cSTSemanticException) {
                        // empty catch block
                    }
                }
                if (element == null) {
                    element = cVar.addNestedElement();
                }
                ConfigurationInitializerRegistry.getInitializer().resolveDefaultValue(element);
            }
        }
    }

    private static class StackFrame {
        private EvaluationAccessor ex;
        private ContainerInitializer init;
        private DecisionVariableDeclaration var;
        private int index = -1;
        private String slot;
        private Value self;

        private StackFrame() {
        }
    }
}

