/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class LocalConfiguration
implements IConfiguration,
IRestrictionEvaluationContext {
    private Map<AbstractVariable, IDecisionVariable> map = new HashMap<AbstractVariable, IDecisionVariable>();

    @Override
    public IDecisionVariable getDecision(AbstractVariable declaration) {
        return this.map.get(declaration);
    }

    public IDecisionVariable addDecision(IDecisionVariable decision) {
        this.map.put(decision.getDeclaration(), decision);
        return decision;
    }

    @Override
    public Value getAllInstances(IDatatype type) {
        Value result;
        try {
            Set set = new Set("", type, null);
            result = ValueFactory.createValue(set, new Object[0]);
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = null;
        }
        return result;
    }

    Value bind(IDatatype type, EvaluationContext context) {
        Value result = null;
        for (IDecisionVariable var : this.map.values()) {
            ReferenceValue ref;
            AbstractVariable decl = var.getDeclaration();
            if ("*r*".equals(decl.getName())) continue;
            IDatatype varType = decl.getType();
            if (TypeQueries.sameTypes(type, varType)) {
                result = var.getValue();
                break;
            }
            if (!(varType instanceof Reference) || !TypeQueries.sameTypes(type, varType = ((Reference)varType).getType()) || (ref = (ReferenceValue)var.getValue()) == null) continue;
            IDecisionVariable refVar = context.getDecision(ref.getValue());
            result = refVar == null ? null : refVar.getValue();
            break;
        }
        return result;
    }

    public void setValue(IVariable variable, Version version) throws RestrictionEvaluationException {
        if (variable instanceof DecisionVariableDeclaration) {
            DecisionVariableDeclaration decl = (DecisionVariableDeclaration)variable;
            IDecisionVariable var = this.getDecision(decl);
            if (var == null) {
                var = this.addDecision(new LocalDecisionVariable(decl, this, null));
            }
            try {
                Value val;
                if (Compound.TYPE.isAssignableFrom(decl.getType())) {
                    if (version == null) {
                        version = Version.NULL_VALUE;
                    }
                    val = ValueFactory.createValue(decl.getType(), "version", version);
                } else {
                    val = ValueFactory.createValue(decl.getType(), version);
                }
                var.setValue(val, AssignmentState.ASSIGNED);
            }
            catch (ValueDoesNotMatchTypeException e) {
                throw new RestrictionEvaluationException(e.getMessage(), e.getId());
            }
            catch (ConfigurationException e) {
                throw new RestrictionEvaluationException(e.getMessage(), e.getId());
            }
        } else {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
    }

    public void unsetValue(IVariable variable) throws RestrictionEvaluationException {
        if (!(variable instanceof DecisionVariableDeclaration)) {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
        this.map.remove((DecisionVariableDeclaration)variable);
    }

    public Object startEvaluation() throws RestrictionEvaluationException {
        return null;
    }

    public void endEvaluation(Object processor) throws RestrictionEvaluationException {
    }

    void rebind(CustomOperation actual, CustomOperation replacement) {
        if (actual.getParameterCount() == replacement.getParameterCount()) {
            int p = 0;
            int n = actual.getParameterCount();
            while (p < n) {
                this.map.put(replacement.getParameterDeclaration(p), this.map.remove(actual.getParameterDeclaration(p)));
                ++p;
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

