/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.VariableAccessor;
import net.ssehub.easy.varModel.model.datatypes.Reference;

public class ReferenceOperations {
    static final IOperationEvaluator REF_BY = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            EvaluationAccessor result = null;
            if (operand != null) {
                IDecisionVariable deref;
                IDecisionVariable var = operand.getVariable();
                if (var != null && (deref = Configuration.dereference(var)) != var) {
                    result = ((VariableAccessor)VariableAccessor.POOL.getInstance()).bind(deref, operand.getContext());
                }
                if (result == null) {
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(operand.getDereferencedValue(), false, operand.getContext());
                }
            }
            return result;
        }
    };

    private ReferenceOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, Reference.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, Reference.EQUALS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, Reference.UNEQUALS, Reference.UNEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, Reference.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, Reference.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IF_DEFINED, Reference.IF_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.COPY, Reference.COPY);
        EvaluatorRegistry.registerEvaluator(REF_BY, Reference.REF_BY);
    }
}

