/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.filter.FilterType;

public abstract class AbstractProjectVisitor
implements IModelVisitor {
    private Project originProject;
    private FilterType filterType;
    private Set<Project> done = new HashSet<Project>();

    protected AbstractProjectVisitor(Project originProject, FilterType filterType) {
        this.originProject = originProject;
        this.filterType = filterType;
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (pImport.getResolved() != null) {
            ((Project)pImport.getResolved()).accept(this);
        }
    }

    @Override
    public void visitProject(Project project) {
        if (!this.done.contains(project)) {
            boolean noImports;
            this.done.add(project);
            boolean importedProject = this.originProject != project;
            int i = 0;
            while (i < project.getImportsCount()) {
                project.getImport(i).accept(this);
                ++i;
            }
            boolean anyProject = FilterType.ALL == this.filterType;
            boolean onlyImports = FilterType.ONLY_IMPORTS == this.filterType && importedProject;
            boolean bl = noImports = FilterType.NO_IMPORTS == this.filterType && !importedProject;
            if (anyProject || onlyImports || noImports) {
                int i2 = 0;
                while (i2 < project.getElementCount()) {
                    project.getElement(i2).accept(this);
                    ++i2;
                }
            }
        }
    }

    protected Project getStartingProject() {
        return this.originProject;
    }

    protected FilterType getFilterType() {
        return this.filterType;
    }

    protected void clear(Project originProject, FilterType filterType) {
        this.done.clear();
        if (originProject != null) {
            this.originProject = originProject;
        }
        if (filterType != null) {
            this.filterType = filterType;
        }
    }
}

