/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDerivedDatatypeListener;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public abstract class AbstractVariable
extends ContainableModelElement
implements IAttributeAccess,
IDerivedDatatypeListener {
    private IDatatype type;
    private ConstraintSyntaxTree defaultValue;

    public AbstractVariable(String name, IDatatype type, IModelElement parent) {
        this(name, type, null, parent);
    }

    public AbstractVariable(String name, IDatatype type, Value defaultValue, IModelElement parent) {
        super(name, parent);
        this.type = type;
        if (type instanceof DerivedDatatype) {
            DerivedDatatype derivedType = (DerivedDatatype)type;
            derivedType.register(this);
        }
        this.constraintsChanged();
        if (defaultValue != null) {
            this.defaultValue = new ConstantValue(defaultValue);
        }
    }

    public void setValue(String value) throws ValueDoesNotMatchTypeException {
        this.defaultValue = value == null ? null : new ConstantValue(ValueFactory.createValue(this.type, value));
    }

    public void setValue(ConstraintSyntaxTree value) throws ValueDoesNotMatchTypeException, CSTSemanticException {
        IDatatype valueType = value.inferDatatype();
        if (!this.type.isAssignableFrom(valueType)) {
            throw new ValueDoesNotMatchTypeException("value is of type '" + IvmlDatatypeVisitor.getUnqualifiedType(valueType) + "' but required is '" + IvmlDatatypeVisitor.getUnqualifiedType(this.type) + "'", 10203);
        }
        this.defaultValue = value;
    }

    public void setValue(Object ... values) throws ValueDoesNotMatchTypeException {
        this.defaultValue = values == null ? null : (1 == values.length && values[0] instanceof Value ? new ConstantValue((Value)values[0]) : (1 == values.length && values[0] instanceof ConstantValue ? (ConstantValue)values[0] : new ConstantValue(ValueFactory.createValue(this.type, values))));
    }

    public ConstraintSyntaxTree getDefaultValue() {
        return this.defaultValue;
    }

    public IDatatype getType() {
        return this.type;
    }

    public boolean isSame(AbstractVariable var) {
        return this.getQualifiedName().equals(var.getQualifiedName()) && this.getType().equals(var.getType());
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && this.getClass().equals(obj.getClass())) {
            AbstractVariable objVar = (AbstractVariable)obj;
            equals = this.isSame(objVar);
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.getQualifiedName().hashCode();
        int typeHashCode = this.type.hashCode();
        if (typeHashCode != 0) {
            hashCode *= typeHashCode;
        }
        return hashCode;
    }

    public abstract boolean isTemporaryVariable();

    @Override
    public void constraintsChanged() {
    }

    public abstract boolean isAttribute();

    public abstract boolean isConstant();
}

