/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.basics.messages.IMessageHandler;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;

public class ExpressionVersionRestrictionValidator
implements IConstraintTreeVisitor {
    private IMessageHandler handler;

    public ExpressionVersionRestrictionValidator(IMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        call.getOperand().accept(this);
        int a = 0;
        while (a < call.getParameterCount()) {
            call.getParameter(a).accept(this);
            ++a;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        this.emit("if-then-else expressions are not allowed here", true, 10106);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        call.getExpression().accept(this);
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        this.emit("unresolved expressions are not allowed here", true, 10106);
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.emit("compound initializers are not allowed here", true, 10106);
    }

    private void emit(String message, boolean error, int code) {
        if (this.handler != null) {
            this.handler.handle(message, error, code);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

