/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public abstract class BasisDatatype
implements IDatatype {
    private String name;
    private DelegatingType singleton;

    protected BasisDatatype(String name, DelegatingType singleton) {
        this.name = name;
        this.singleton = singleton;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameSpace() {
        return "";
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    @Override
    public final Operation getOperation(int index) {
        return this.singleton.getOperation(index);
    }

    @Override
    public final int getOperationCount() {
        return this.singleton.getOperationCount();
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        boolean isAssignable;
        boolean bl = isAssignable = this.singleton.equals(type) || AnyType.TYPE == type;
        if (!isAssignable && type instanceof DerivedDatatype) {
            DerivedDatatype derived = (DerivedDatatype)type;
            isAssignable = this.isAssignableFrom(derived.getBasisType());
        }
        return isAssignable;
    }

    @Override
    public Class<? extends IDatatype> getTypeClass() {
        return this.singleton.getTypeClass();
    }

    @Override
    public IDatatype getType() {
        return this;
    }

    @Override
    public IDatatype getGenericType(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getGenericTypeCount() {
        return 0;
    }

    @Override
    public abstract void accept(IDatatypeVisitor var1);

    @Override
    public boolean isPseudoType() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

