/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class TypeQueries {
    public static Operation getOperation(IDatatype operand, String name, IDatatype ... parameter) {
        Operation result = null;
        Operation fallBack = null;
        if (operand != null) {
            boolean noAny = operand instanceof ConstraintType;
            int o = 0;
            while (result == null && o <= operand.getOperationCount() - 1) {
                Operation tmp = operand.getOperation(o);
                if (tmp.getName().equals(name)) {
                    int tmpParamCount = tmp.getParameterCount();
                    if (parameter == null) {
                        if (tmpParamCount == 0) {
                            result = tmp;
                        }
                    } else if (parameter.length == tmpParamCount) {
                        boolean register;
                        boolean eq = noAny && tmp.getOperand() != AnyType.TYPE || !noAny;
                        int p = 0;
                        while (eq && p < tmpParamCount) {
                            IDatatype specifiedType = tmp.getParameterType(p);
                            IDatatype givenType = parameter[p];
                            if (specifiedType != null && givenType != null) {
                                eq = specifiedType.isAssignableFrom(givenType) || givenType.getTypeClass() == specifiedType.getTypeClass();
                            }
                            ++p;
                        }
                        boolean bl = register = eq && result == null;
                        if (register && tmp.isFallback()) {
                            fallBack = tmp;
                        } else if (register) {
                            result = tmp;
                        }
                    }
                }
                ++o;
            }
        }
        if (result == null) {
            result = fallBack;
        }
        return result;
    }

    public static boolean sameTypes(IDatatype type1, IDatatype type2) {
        boolean same = AnyType.TYPE == type1 ? TypeQueries.isAnyType(type2) : (AnyType.TYPE == type2 ? TypeQueries.isAnyType(type1) : (type1 != null && type2 != null ? type1.isAssignableFrom(type2) && type2.isAssignableFrom(type1) : false));
        return same;
    }

    public static boolean isAnyType(IDatatype type) {
        return AnyType.TYPE == type || type instanceof AnyType;
    }

    public static boolean isEnum(IDatatype type) {
        return Enum.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isFreezeVariableType(IDatatype type) {
        return FreezeVariableType.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isReference(IDatatype type) {
        return Reference.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isConstraint(IDatatype type) {
        boolean isConstraint;
        boolean bl = isConstraint = ConstraintType.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
        if (isConstraint) {
            IDatatype res = TypeQueries.resolveFully(type.getType());
            isConstraint = res != BooleanType.TYPE && res != BooleanType.TYPE.getType();
        }
        return isConstraint;
    }

    public static boolean isCompound(IDatatype type) {
        return Compound.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isContainer(IDatatype type) {
        return Container.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isSet(IDatatype type) {
        return Set.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isSequence(IDatatype type) {
        return Set.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static IDatatype findDeepestGeneric(IDatatype type, int pos) {
        IDatatype result = pos >= 0 && pos < type.getGenericTypeCount() ? TypeQueries.findDeepestGeneric(type.getGenericType(pos), pos) : (Container.TYPE.isAssignableFrom(type) ? AnyType.TYPE : type);
        return result;
    }

    public static IDatatype[] toGenerics(IDatatype type) {
        int count = type.getGenericTypeCount();
        IDatatype[] param = new IDatatype[count];
        int g = 0;
        while (g < count) {
            param[g] = type.getGenericType(g);
            ++g;
        }
        return param;
    }

    public static IDatatype resolveFully(IDatatype type) {
        IDatatype result;
        IDatatype iter = type;
        while (iter != (result = Reference.dereference(DerivedDatatype.resolveToBasis(iter)))) {
            iter = result;
        }
        return result;
    }
}

