/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.DecisionVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.StructuredVariable;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public abstract class ContainerVariable
extends StructuredVariable {
    private List<IDecisionVariable> nestedElements;

    protected ContainerVariable(IConfigurationElement parent, AbstractVariable varDeclaration, boolean isVisible, boolean isAttribute) {
        super(parent, varDeclaration, isVisible, isAttribute);
        if (this.nestedElements == null) {
            this.nestedElements = new ArrayList<IDecisionVariable>();
        }
    }

    void clear() {
        this.nestedElements.clear();
    }

    @Override
    public int getNestedElementsCount() {
        return this.nestedElements == null ? 0 : this.nestedElements.size();
    }

    @Override
    public IDecisionVariable getNestedElement(int index) {
        return this.nestedElements.get(index);
    }

    public int indexOf(IDecisionVariable var) {
        return this.nestedElements.indexOf(var);
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        this.nestedElements.clear();
        ContainerValue conValue = (ContainerValue)value;
        IDatatype type = DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
        type = ((Container)type).getContainedType();
        int i = 0;
        while (conValue != null && i < conValue.getElementSize()) {
            String name = this.getElementName(i);
            Value eltValue = conValue.getElement(i);
            DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, eltValue.getType(), this.getDeclaration());
            VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
            IDecisionVariable var = creator.getVariable();
            var.setValue(eltValue, state);
            eltValue.setValueParent(var);
            this.nestedElements.add(var);
            ++i;
        }
    }

    @Override
    public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        ContainerValue conValue = null;
        if (value == NullValue.INSTANCE) {
            this.nestedElements.clear();
        } else if (value instanceof ContainerValue) {
            conValue = (ContainerValue)value;
            IDatatype type = DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
            type = ((Container)type).getContainedType();
            if (conValue != null) {
                while (this.nestedElements.size() > conValue.getElementSize()) {
                    this.nestedElements.remove(0);
                }
                int i = 0;
                while (i < conValue.getElementSize()) {
                    boolean createNewVar = true;
                    if (this.nestedElements.size() > i) {
                        IDecisionVariable oldVar = this.nestedElements.get(i);
                        Value trgValue = conValue.getElement(i);
                        boolean bl = createNewVar = trgValue == null || !trgValue.equals(oldVar.getValue());
                        if (createNewVar) {
                            boolean bl2 = createNewVar = AssignmentState.USER_ASSIGNED != oldVar.getState() || AssignmentState.USER_ASSIGNED == state;
                        }
                    }
                    if (createNewVar) {
                        String name = this.getElementName(i);
                        IDatatype eltType = conValue.getElement(i).getType();
                        DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, eltType, this.getDeclaration());
                        VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
                        try {
                            IDecisionVariable var = creator.getVariable();
                            this.addNestedElement(var);
                        }
                        catch (ConfigurationException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
        super.setValue(value, state);
        if (conValue != null) {
            int i = 0;
            while (i < conValue.getElementSize()) {
                IDecisionVariable nestedVariable = this.getNestedElement(i);
                if (AssignmentState.USER_ASSIGNED != nestedVariable.getState() || state == AssignmentState.USER_ASSIGNED) {
                    Value nestedValue = conValue.getElement(i);
                    nestedVariable.setValue(nestedValue, state);
                    nestedValue.setValueParent(nestedVariable);
                }
                ++i;
            }
        }
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        super.freeze(selector);
        for (IDecisionVariable var : this.nestedElements) {
            var.freeze(selector);
        }
    }

    @Override
    public void freeze(String nestedElement) {
    }

    @Override
    boolean allowsNestedStates() {
        return true;
    }

    protected String getElementName(int index) {
        return "" + index;
    }

    public IDecisionVariable addNestedElement() {
        return this.addNestedElement((IDatatype)null);
    }

    public IDatatype getContainedType() {
        return ((Container)DerivedDatatype.resolveToBasis(this.getDeclaration().getType())).getContainedType();
    }

    public IDecisionVariable addNestedElement(IDatatype type) {
        if (this.getValue() == null) {
            try {
                Value containerValue = ValueFactory.createValue(this.getDeclaration().getType(), null);
                this.setValue(containerValue, AssignmentState.UNDEFINED);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
        }
        IDecisionVariable result = null;
        IDatatype baseType = this.getContainedType();
        if (type == null || !baseType.isAssignableFrom(type)) {
            type = baseType;
        }
        int elementPos = this.nestedElements.size();
        try {
            String name = this.getElementName(elementPos);
            DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, type, this.getDeclaration());
            VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
            result = creator.getVariable(false);
            this.addNestedElement(result);
            Value nullValue = ValueFactory.createValue(type, null);
            result.setValue(nullValue, AssignmentState.UNDEFINED);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (ValueDoesNotMatchTypeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean removeNestedElement(IDecisionVariable var) {
        int index = this.nestedElements.indexOf(var);
        if (-1 != index) {
            this.nestedElements.remove(index);
            Object[] copiedValues = new Object[this.nestedElements.size()];
            int i = 0;
            while (i < this.nestedElements.size()) {
                copiedValues[i] = this.nestedElements.get(i).getValue();
                ++i;
            }
            i = index;
            while (i < this.nestedElements.size()) {
                ((DecisionVariable)this.nestedElements.get(i)).setIndex(i);
                ++i;
            }
            try {
                Value newValue = ValueFactory.createValue(this.getDeclaration().getType(), copiedValues);
                super.setValue(newValue, AssignmentState.ASSIGNED);
            }
            catch (ValueDoesNotMatchTypeException e) {
                Bundle.getLogger(ContainerValue.class).exception((Exception)e);
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception((Exception)e);
            }
        }
        return -1 != index;
    }

    @Override
    public IAssignmentState getState() {
        IAssignmentState state = super.getState();
        if (state != AssignmentState.FROZEN && this.ownStateAllowed() && this.getValue() != NullValue.INSTANCE) {
            if (this.getValue() == null || this.getValue().getValue() == null) {
                state = AssignmentState.UNDEFINED;
            } else if (state == AssignmentState.UNDEFINED && this.nestedElements.size() > 0) {
                state = AssignmentState.ASSIGNED;
            }
        }
        return state;
    }

    void addNestedElement(IDecisionVariable var) {
        boolean found = false;
        int i = 0;
        while (i < this.getNestedElementsCount() && !found) {
            IDecisionVariable oldVar = this.nestedElements.get(i);
            if (oldVar.getDeclaration().getName().equals(var.getDeclaration().getName())) {
                found = true;
                this.nestedElements.set(i, var);
            }
            ++i;
        }
        if (!found) {
            if (this.nestedElements == null) {
                this.nestedElements = new ArrayList<IDecisionVariable>();
            }
            this.nestedElements.add(var);
        }
    }

    @Override
    public boolean removeDerivedValues() {
        boolean changed = false;
        IAssignmentState oldState = this.getState();
        ArrayList<IDecisionVariable> copiedValues = new ArrayList<IDecisionVariable>();
        int i = 0;
        int n = this.nestedElements.size();
        while (i < n) {
            if (AssignmentState.DERIVED != this.nestedElements.get(i).getState()) {
                copiedValues.add(this.nestedElements.get(i));
            }
            ++i;
        }
        if (copiedValues.isEmpty()) {
            try {
                this.setValue(null, AssignmentState.UNDEFINED);
                changed = true;
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception((Exception)e);
            }
        } else if (copiedValues.size() < this.nestedElements.size()) {
            i = 0;
            while (i < copiedValues.size()) {
                ((DecisionVariable)copiedValues.get(i)).setIndex(i);
                ++i;
            }
            try {
                Value newValue = ValueFactory.createValue(this.getDeclaration().getType(), copiedValues.toArray());
                super.setValue(newValue, oldState);
            }
            catch (ValueDoesNotMatchTypeException e) {
                Bundle.getLogger(ContainerValue.class).exception((Exception)e);
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception((Exception)e);
            }
            changed = true;
        }
        if (!this.nestedElements.isEmpty()) {
            i = 0;
            n = this.nestedElements.size();
            while (i < n) {
                changed &= this.nestedElements.get(i).removeDerivedValues();
                ++i;
            }
        }
        return changed;
    }

    @Override
    public boolean notifyWasAssigned(Value value) {
        boolean old = this.wasAssigned();
        super.notifyWasAssigned(value);
        if (value instanceof ContainerValue) {
            ContainerValue cValue = (ContainerValue)value;
            int n = 0;
            while (n < Math.min(this.getNestedElementsCount(), cValue.getElementSize())) {
                this.getNestedElement(n).notifyWasAssigned(cValue.getElement(n));
                ++n;
            }
        }
        return old;
    }
}

