/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.model.values.VersionValue;

class ConstantValueResolver
implements IValueVisitor {
    private EvaluationVisitor evaluator;
    private Value value;

    ConstantValueResolver(EvaluationVisitor evaluator) {
        this.evaluator = evaluator;
    }

    Value getValue() {
        Value result = this.value;
        this.value = null;
        return result;
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
        this.value = value;
    }

    @Override
    public void visitEnumValue(EnumValue value) {
        this.value = value;
    }

    @Override
    public void visitStringValue(StringValue value) {
        this.value = value;
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
        boolean ok = true;
        CompoundValue result = value.clone();
        for (String slot : value.getSlotNames()) {
            Value nested = value.getNestedValue(slot);
            if (nested == null) continue;
            nested.accept(this);
            Value val = this.getValue();
            if (val == null) {
                ok = false;
                continue;
            }
            try {
                result.configureValue(slot, val);
            }
            catch (ValueDoesNotMatchTypeException e) {
                EASyLoggerFactory.INSTANCE.getLogger(ConstantValueResolver.class, "net.ssehub.easy.varModel").exception((Exception)e);
                ok = false;
            }
        }
        this.value = ok ? result : null;
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
        boolean ok = true;
        ContainerValue result = null;
        try {
            result = (ContainerValue)ValueFactory.createValue(value.getType(), new Object[0]);
        }
        catch (ValueDoesNotMatchTypeException e) {
            ok = false;
        }
        int i = 0;
        while (ok && i < value.getElementSize()) {
            Value nested = value.getElement(i);
            if (nested != null) {
                nested.accept(this);
                Value val = this.getValue();
                if (val == null) {
                    ok = false;
                } else {
                    try {
                        result.addElement(val);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(ConstantValueResolver.class, "net.ssehub.easy.varModel").exception((Exception)e);
                        ok = false;
                    }
                }
            }
            ++i;
        }
        this.value = ok ? result : null;
    }

    @Override
    public void visitIntValue(IntValue value) {
        this.value = value;
    }

    @Override
    public void visitRealValue(RealValue value) {
        this.value = value;
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
        this.value = value;
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
        Value result = referenceValue;
        if (referenceValue.getValueEx() != null) {
            referenceValue.getValueEx().accept(this.evaluator);
            EvaluationAccessor acc = this.evaluator.getResultAccessor(false);
            if (acc != null) {
                Value tmp = acc.getReferenceValue();
                result = tmp != null ? tmp.clone() : null;
                this.evaluator.clearResult();
            }
        }
        this.value = result;
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
        this.value = value;
    }

    @Override
    public void visitNullValue(NullValue value) {
        this.value = value;
    }

    @Override
    public void visitVersionValue(VersionValue value) {
        this.value = value;
    }
}

