/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.IIteratorEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.ListWrapperValue;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

class ContainerIterators {
    static final IIteratorEvaluator APPLY = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            return BooleanValue.FALSE;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return null;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator FOR_ALL = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            if (!BooleanValue.TRUE.equals(result.getValue()) || !BooleanValue.TRUE.equals(value.getValue())) {
                result.setValue(BooleanValue.FALSE, false);
            }
            return BooleanValue.FALSE;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return BooleanValue.TRUE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator EXISTS = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            BooleanValue stop;
            if (BooleanValue.TRUE.equals(value.getValue())) {
                result.setValue(BooleanValue.TRUE, false);
                stop = BooleanValue.TRUE;
            } else {
                stop = BooleanValue.FALSE;
            }
            return stop;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return BooleanValue.FALSE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator IS_UNIQUE = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            BooleanValue stop;
            Value val = value.getValue();
            if (data.containsKey(val)) {
                stop = BooleanValue.TRUE;
                result.setValue(BooleanValue.FALSE, false);
            } else {
                data.put(val, null);
                stop = BooleanValue.FALSE;
            }
            return stop;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return BooleanValue.TRUE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator ANY = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) {
            BooleanValue stop;
            if (BooleanValue.TRUE.equals(value.getValue())) {
                stop = BooleanValue.TRUE;
                result.setValue(iter, false);
                result.addBoundContainerElement(value.getVariable());
            } else {
                stop = BooleanValue.FALSE;
            }
            return stop;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return NullValue.INSTANCE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator ONE = new IIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            BooleanValue stop;
            if (BooleanValue.TRUE.equals(value.getValue())) {
                stop = BooleanValue.toBooleanValue(!NullValue.INSTANCE.equals(result.getValue()));
                result.setValue(iter, false);
                result.addBoundContainerElement(value.getVariable());
            } else {
                stop = BooleanValue.FALSE;
            }
            return stop;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return NullValue.INSTANCE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    };
    static final IIteratorEvaluator MIN2 = new NumberIteratorEvaluator(){

        @Override
        protected int intOp(int i1, int i2) {
            return Math.min(i1, i2);
        }

        @Override
        protected double doubleOp(double d1, double d2) {
            return Math.min(d1, d2);
        }
    };
    static final IIteratorEvaluator MAX2 = new NumberIteratorEvaluator(){

        @Override
        protected int intOp(int i1, int i2) {
            return Math.max(i1, i2);
        }

        @Override
        protected double doubleOp(double d1, double d2) {
            return Math.max(d1, d2);
        }
    };
    static final IIteratorEvaluator COLLECT = new CollectingIteratorEvaluator(){

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            Value cVal = result.getValue();
            if (cVal instanceof ContainerValue) {
                ((ContainerValue)cVal).addElement(value.getValue());
                result.addBoundContainerElement(value.getVariable());
            }
            return BooleanValue.FALSE;
        }
    };
    static final IIteratorEvaluator CLOSURE = new ClosureIteratorEvaluator(false);
    static final IIteratorEvaluator IS_ACYCLIC = new ClosureIteratorEvaluator(true){

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return BooleanValue.TRUE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            result.setValue(BooleanValue.toBooleanValue(!this.hasCycle(data)), false);
        }
    };
    static final IIteratorEvaluator SORTED_BY = new CollectingIteratorEvaluator(){
        private static final String KEY_SORTED_BY = "sortedBy";

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            TreeMap<Value, ArrayList<Value>> keyMap;
            Object tmp = data.get(KEY_SORTED_BY);
            if (tmp == null) {
                IDatatype eltType = result.getValue().getContainedType();
                Comparator<Value> cmp = IntegerType.TYPE.isAssignableFrom(eltType) ? INT_COMPARATOR : (RealType.TYPE.isAssignableFrom(eltType) ? REAL_COMPARATOR : new DefaultValueComparator(result.getContext().getCollator()));
                keyMap = new TreeMap<Value, ArrayList<Value>>(cmp);
                data.put(KEY_SORTED_BY, keyMap);
            } else {
                keyMap = (TreeMap<Value, ArrayList<Value>>)tmp;
            }
            Value cVal = result.getValue();
            if (cVal instanceof ContainerValue) {
                Value key = value.getValue();
                ArrayList<Value> keyValues = (ArrayList<Value>)keyMap.get(key);
                if (keyValues == null) {
                    keyValues = new ArrayList<Value>();
                    keyMap.put(key, keyValues);
                }
                keyValues.add(iter);
            }
            return BooleanValue.FALSE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            Value rVal = result.getValue();
            Object tmp = data.get(KEY_SORTED_BY);
            if (tmp != null && rVal instanceof ContainerValue) {
                ContainerValue container = (ContainerValue)rVal;
                TreeMap keyMap = (TreeMap)tmp;
                for (List valList : keyMap.values()) {
                    for (Value val : valList) {
                        container.addElement(val);
                    }
                }
            }
        }
    };
    private static final Object DATA_CLOSURE_MARKED = new Object();
    private static final Object DATA_CLOSURE_CYCLIC = new Object();
    private static final Comparator<Value> INT_COMPARATOR = new Comparator<Value>(){

        @Override
        public int compare(Value o1, Value o2) {
            Integer i1 = ((IntValue)o1).getValue();
            Integer i2 = ((IntValue)o2).getValue();
            return i1.compareTo(i2);
        }
    };
    private static final Comparator<Value> REAL_COMPARATOR = new Comparator<Value>(){

        @Override
        public int compare(Value o1, Value o2) {
            Double d1 = ((RealValue)o1).getValue();
            Double d2 = ((RealValue)o2).getValue();
            return d1.compareTo(d2);
        }
    };

    private ContainerIterators() {
    }

    private static class ClosureIteratorEvaluator
    extends CollectingIteratorEvaluator {
        private boolean stopOnCycle = false;

        private ClosureIteratorEvaluator(boolean stopOnCycle) {
            this.stopOnCycle = stopOnCycle;
        }

        @Override
        public Value aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            Value rValue = result.getValue();
            ArrayList<Value> nextValues = null;
            ContainerValue resultContainer = rValue instanceof ContainerValue ? (ContainerValue)rValue : null;
            this.handleResult(this.handleNextValue(iter, resultContainer, data, nextValues), result, value, -1);
            nextValues = new ArrayList<Value>();
            Value val = value.getValue();
            if (val instanceof ContainerValue) {
                ContainerValue valContainer = (ContainerValue)val;
                int e = 0;
                while (e < valContainer.getElementSize()) {
                    this.handleResult(this.handleNextValue(valContainer.getElement(e), resultContainer, data, nextValues), result, value, e);
                    if (!this.stopOnCycle || !this.hasCycle(data)) {
                        ++e;
                        continue;
                    }
                    break;
                }
            } else if (val instanceof ReferenceValue) {
                this.handleResult(this.handleNextValue(val, resultContainer, data, nextValues), result, value, -1);
            }
            Value res = BooleanValue.FALSE;
            if (this.stopOnCycle && this.hasCycle(data)) {
                res = BooleanValue.TRUE;
            } else if (nextValues != null) {
                res = new ListWrapperValue(nextValues);
            }
            return res;
        }

        protected boolean hasCycle(Map<Object, Object> data) {
            return Boolean.TRUE == data.get(DATA_CLOSURE_CYCLIC);
        }

        private boolean handleNextValue(Value value, ContainerValue result, Map<Object, Object> data, List<Value> nextValues) throws ValueDoesNotMatchTypeException {
            boolean changed = false;
            HashSet<Value> marking = (HashSet<Value>)data.get(DATA_CLOSURE_MARKED);
            if (marking == null) {
                marking = new HashSet<Value>();
                data.put(DATA_CLOSURE_MARKED, marking);
            }
            if (!marking.contains(value)) {
                if (nextValues != null) {
                    nextValues.add(value);
                } else {
                    if (result != null) {
                        result.addElement(value);
                        changed = true;
                    }
                    marking.add(value);
                }
            } else {
                data.put(DATA_CLOSURE_CYCLIC, Boolean.TRUE);
            }
            return changed;
        }

        private void handleResult(boolean changed, EvaluationAccessor result, EvaluationAccessor value, int index) {
            if (changed) {
                if (index >= 0) {
                    result.addBoundContainerElement(value, index);
                } else {
                    result.addBoundContainerElement(value.getVariable());
                }
            }
        }
    }

    static class CollectIteratorEvaluator
    extends CollectingIteratorEvaluator {
        private BooleanValue condition;

        CollectIteratorEvaluator(BooleanValue condition) {
            this.condition = condition;
        }

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            Value cVal = result.getValue();
            if (this.condition.equals(value.getValue()) && cVal instanceof ContainerValue) {
                ((ContainerValue)cVal).addElement(iter);
                result.addBoundContainerElement(value.getVariable());
            }
            return BooleanValue.FALSE;
        }
    }

    static abstract class CollectingIteratorEvaluator
    implements IIteratorEvaluator {
        CollectingIteratorEvaluator() {
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return ValueFactory.createValue(type, null);
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    }

    private static class DefaultValueComparator
    implements Comparator<Value> {
        private Collator collator;

        private DefaultValueComparator(Collator collator) {
            this.collator = collator;
        }

        @Override
        public int compare(Value o1, Value o2) {
            return this.collator.compare(StringProvider.toIvmlString(o1), StringProvider.toIvmlString(o2));
        }
    }

    private static abstract class NumberIteratorEvaluator
    implements IIteratorEvaluator {
        private NumberIteratorEvaluator() {
        }

        protected abstract int intOp(int var1, int var2);

        protected abstract double doubleOp(double var1, double var3);

        @Override
        public BooleanValue aggregate(EvaluationAccessor result, Value iter, EvaluationAccessor value, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
            Value val = value.getValue();
            Number newVal = null;
            if (val instanceof IntValue) {
                int v = ((IntValue)value.getValue()).getValue();
                if (data.containsKey(this)) {
                    int oldVal = (Integer)data.get(this);
                    int res = this.intOp(oldVal, v);
                    if (res != oldVal) {
                        newVal = res;
                    }
                } else {
                    newVal = v;
                }
            } else if (val instanceof RealValue) {
                double v = ((RealValue)value.getValue()).getValue();
                if (data.containsKey(this)) {
                    double oldVal = (Double)data.get(this);
                    double res = this.doubleOp(oldVal, v);
                    if (res != oldVal) {
                        newVal = res;
                    }
                } else {
                    newVal = v;
                }
            }
            if (newVal != null) {
                data.put(this, newVal);
                result.setValue(iter, false);
            }
            return BooleanValue.FALSE;
        }

        @Override
        public Value getStartResult(IDatatype type, IDatatype iterType) throws ValueDoesNotMatchTypeException {
            return NullValue.INSTANCE;
        }

        @Override
        public void postProcessResult(EvaluationAccessor result, Map<Object, Object> data) throws ValueDoesNotMatchTypeException {
        }
    }
}

