/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.ContainerIterators;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericNumberOperations;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ContainerOperations {
    static final Pool<ContainerArgument> CA_POOL = new Pool((IPoolManager)new IPoolManager<ContainerArgument>(){

        public ContainerArgument create() {
            return new ContainerArgument();
        }

        public void clear(ContainerArgument instance) {
            instance.clear();
        }
    });
    static final IOperationEvaluator SIZE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result;
            Value opValue = operand.getValue();
            if (opValue instanceof ContainerValue) {
                try {
                    Value val = ValueFactory.createValue(IntegerType.TYPE, ((ContainerValue)opValue).getElementSize());
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(val, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    operand.getContext().addErrorMessage(e);
                    result = null;
                }
            } else {
                if (opValue != null && NullValue.INSTANCE != opValue) {
                    operand.getContext().addErrorMessage("operand is no Container: " + IvmlDatatypeVisitor.getQualifiedType(opValue.getType()), 102);
                }
                result = null;
            }
            return result;
        }
    };
    static final IOperationEvaluator ADD = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value oValue = operand.getValue();
                Value aValue = arguments[0].getValue();
                if (oValue instanceof ContainerValue && aValue != null) {
                    ContainerValue cont = (ContainerValue)oValue;
                    try {
                        cont.addElement(aValue);
                        result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(aValue, false, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                    }
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator AVG = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value opValue = operand.getValue();
            if (opValue instanceof ContainerValue) {
                ContainerValue cont = (ContainerValue)opValue;
                boolean isInt = TypeQueries.sameTypes(IntegerType.TYPE, cont.getContainedType());
                boolean isReal = TypeQueries.sameTypes(RealType.TYPE, cont.getContainedType());
                if (isInt || isReal) {
                    double sum = 0.0;
                    int size = cont.getElementSize();
                    if (size > 0) {
                        if (isInt) {
                            i = 0;
                            while (i < size) {
                                Value elt = cont.getElement(i);
                                sum += (double)((IntValue)elt).getValue().intValue();
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < size) {
                                Value elt = cont.getElement(i);
                                sum += ((RealValue)elt).getValue().doubleValue();
                                ++i;
                            }
                        }
                        sum /= (double)size;
                    }
                    try {
                        Value rValue = isInt ? ValueFactory.createValue(IntegerType.TYPE, (int)sum) : ValueFactory.createValue(RealType.TYPE, sum);
                        result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                    }
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator AS_SET = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return ContainerOperations.convert(operand, Set.TYPE);
        }
    };
    static final IOperationEvaluator AS_SEQUENCE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return ContainerOperations.convert(operand, Sequence.TYPE);
        }
    };
    static final IOperationEvaluator MIN = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return ContainerOperations.min(operand, arguments);
        }
    };
    static final IOperationEvaluator MAX = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return ContainerOperations.max(operand, arguments);
        }
    };
    static final IOperationEvaluator INTERSECT = new Container2OperationEvaluator(new Container2Operation(){

        @Override
        public void evaluate(ContainerArgument c1, ContainerArgument c2, List<Value> result, EvaluationAccessor resultAcc) {
            HashSet<Value> done = new HashSet<Value>();
            ContainerValue cv1 = c1.getValue();
            EvaluationAccessor c1Acc = c1.getAccessor();
            ContainerValue cv2 = c2.getValue();
            int a = 0;
            while (a < cv2.getElementSize()) {
                done.add(cv2.getElement(a));
                ++a;
            }
            int o = 0;
            while (o < cv1.getElementSize()) {
                Value elt = cv1.getElement(o);
                if (done.contains(elt)) {
                    result.add(elt);
                    resultAcc.addBoundContainerElement(c1Acc, o);
                }
                ++o;
            }
        }
    });
    static final IOperationEvaluator COUNT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value oValue = operand.getValue();
                Value aValue = arguments[0].getValue();
                if (oValue instanceof ContainerValue) {
                    ContainerValue cValue = (ContainerValue)oValue;
                    int size = cValue.getElementSize();
                    int count = 0;
                    int i = 0;
                    while (i < size) {
                        if (cValue.getElement(i).equals(aValue)) {
                            ++count;
                        }
                        ++i;
                    }
                    try {
                        Value rValue = ValueFactory.createValue(IntegerType.TYPE, count);
                        result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                    }
                }
            }
            return result;
        }
    };

    private ContainerOperations() {
    }

    public static void register() {
        EvaluatorRegistry.registerEvaluator(SIZE, Container.SIZE);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, Container.UNEQUALS, Container.UNEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(new FindOperationEvaluator(false), Container.INCLUDES);
        EvaluatorRegistry.registerEvaluator(new FindOperationEvaluator(true), Container.EXCLUDES);
        EvaluatorRegistry.registerEvaluator(new IncludesAllOperationEvaluator(false), Container.INCLUDES_ALL);
        EvaluatorRegistry.registerEvaluator(new IncludesAllOperationEvaluator(true), Container.EXCLUDES_ALL);
        EvaluatorRegistry.registerEvaluator(COUNT, Container.COUNT);
        EvaluatorRegistry.registerEvaluator(new IsEmptyOperationEvaluator(false), Container.IS_EMPTY);
        EvaluatorRegistry.registerEvaluator(new IsEmptyOperationEvaluator(true), Container.NOT_EMPTY);
        EvaluatorRegistry.registerEvaluator(new CalcEvaluator(false), Container.SUM);
        EvaluatorRegistry.registerEvaluator(new CalcEvaluator(true), Container.PRODUCT);
        EvaluatorRegistry.registerEvaluator(MIN, Container.MIN);
        EvaluatorRegistry.registerEvaluator(MAX, Container.MAX);
        EvaluatorRegistry.registerEvaluator(AVG, Container.AVG);
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, Container.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.APPLY, Container.APPLY);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.APPLY, Container.ITERATE);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.FOR_ALL, Container.FORALL);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.EXISTS, Container.EXISTS);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.ANY, Container.ANY);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.ONE, Container.ONE);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.MIN2, Container.MIN2);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.MAX2, Container.MAX2);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.IS_UNIQUE, Container.IS_UNIQUE);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.COLLECT, Container.COLLECT);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.COLLECT, Container.COLLECT_NESTED);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.IS_ACYCLIC, Container.IS_ACYCLIC);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.CLOSURE, Container.CLOSURE);
        EvaluatorRegistry.registerEvaluator(ContainerIterators.SORTED_BY, Container.SORTED_BY);
        EvaluatorRegistry.registerEvaluator(new ContainerIterators.CollectIteratorEvaluator(BooleanValue.TRUE), Container.SELECT);
        EvaluatorRegistry.registerEvaluator(new ContainerIterators.CollectIteratorEvaluator(BooleanValue.FALSE), Container.REJECT);
        EvaluatorRegistry.registerEvaluator(new TypeSelectEvaluator(false, true), Container.TYPE_SELECT);
        EvaluatorRegistry.registerEvaluator(new TypeSelectEvaluator(false, false), Container.SELECT_BY_TYPE);
        EvaluatorRegistry.registerEvaluator(new TypeSelectEvaluator(false, true), Container.SELECT_BY_KIND);
        EvaluatorRegistry.registerEvaluator(new TypeSelectEvaluator(true, true), Container.TYPE_REJECT);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, Container.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IF_DEFINED, Container.IF_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.COPY, Container.COPY);
    }

    private static final EvaluationAccessor convert(EvaluationAccessor operand, IDatatype targetType) {
        ConstantAccessor result = null;
        Value oVal = operand.getValue();
        if (oVal instanceof ContainerValue) {
            ContainerValue cont = (ContainerValue)oVal;
            result = (ConstantAccessor)ConstantAccessor.POOL.getInstance();
            try {
                Value rValue;
                if (Set.TYPE.isAssignableFrom(targetType)) {
                    if (1 == oVal.getType().getGenericTypeCount()) {
                        targetType = new Set("set", oVal.getType().getGenericType(0), null);
                    }
                    HashSet<Value> done = new HashSet<Value>();
                    ArrayList<Value> tmp = new ArrayList<Value>();
                    int i = 0;
                    while (i < cont.getElementSize()) {
                        Value elt = cont.getElement(i);
                        if (!done.contains(elt)) {
                            done.add(elt);
                            tmp.add(elt);
                            result.addBoundContainerElement(operand, i);
                        }
                        ++i;
                    }
                    Object[] array = new Object[tmp.size()];
                    tmp.toArray(array);
                    rValue = ValueFactory.createValue(targetType, array);
                } else {
                    rValue = ValueFactory.createValue(targetType, null);
                    rValue.setValue(cont);
                }
                result.bind(rValue, false, operand.getContext());
            }
            catch (ValueDoesNotMatchTypeException e) {
                operand.getContext().addErrorMessage(e);
                result = EvaluationAccessor.release(result);
            }
        }
        return result;
    }

    private static final EvaluationAccessor min(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
        ConstantAccessor result = null;
        Value oVal = operand.getValue();
        if (oVal instanceof ContainerValue) {
            ContainerValue cont = (ContainerValue)oVal;
            IDatatype contType = ((Container)cont.getType()).getContainedType();
            int contSize = cont.getElementSize();
            if (contSize > 0) {
                Value rValue = null;
                if (contType.isAssignableFrom(RealType.TYPE)) {
                    double min = (Double)cont.getElement(0).getValue();
                    int i = 1;
                    while (i < contSize) {
                        double tmp = (Double)cont.getElement(i).getValue();
                        if (tmp < min) {
                            min = tmp;
                        }
                        ++i;
                    }
                    try {
                        rValue = ValueFactory.createValue(contType, min);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").debug(e.getMessage());
                    }
                } else if (contType.isAssignableFrom(IntegerType.TYPE)) {
                    int min = (Integer)cont.getElement(0).getValue();
                    int i = 1;
                    while (i < contSize) {
                        int tmp = (Integer)cont.getElement(i).getValue();
                        if (tmp < min) {
                            min = tmp;
                        }
                        ++i;
                    }
                    try {
                        rValue = ValueFactory.createValue(contType, min);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").debug(e.getMessage());
                    }
                }
                if (rValue != null) {
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, true, operand.getContext());
                }
            }
        }
        return result;
    }

    private static final EvaluationAccessor max(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
        ConstantAccessor result = null;
        Value oVal = operand.getValue();
        if (oVal instanceof ContainerValue) {
            ContainerValue cont = (ContainerValue)oVal;
            IDatatype contType = ((Container)cont.getType()).getContainedType();
            int contSize = cont.getElementSize();
            if (contSize > 0) {
                Value rValue = null;
                if (contType.isAssignableFrom(RealType.TYPE)) {
                    double max = (Double)cont.getElement(0).getValue();
                    int i = 1;
                    while (i < contSize) {
                        double tmp = (Double)cont.getElement(i).getValue();
                        if (tmp > max) {
                            max = tmp;
                        }
                        ++i;
                    }
                    try {
                        rValue = ValueFactory.createValue(contType, max);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").debug(e.getMessage());
                    }
                } else if (contType.isAssignableFrom(IntegerType.TYPE)) {
                    int max = (Integer)cont.getElement(0).getValue();
                    int i = 1;
                    while (i < contSize) {
                        int tmp = (Integer)cont.getElement(i).getValue();
                        if (tmp > max) {
                            max = tmp;
                        }
                        ++i;
                    }
                    try {
                        rValue = ValueFactory.createValue(contType, max);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").debug(e.getMessage());
                    }
                }
                if (rValue != null) {
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, true, operand.getContext());
                }
            }
        }
        return result;
    }

    static final void addAll(ContainerArgument cnt, List<Value> result, EvaluationAccessor resAcc) {
        ContainerValue cont = cnt.getValue();
        EvaluationAccessor contAcc = cnt.getAccessor();
        int i = 0;
        while (i < cont.getElementSize()) {
            result.add(cont.getElement(i));
            resAcc.addBoundContainerElement(contAcc, i);
            ++i;
        }
    }

    static final void addAll(ContainerArgument cnt, java.util.Set<Value> result, EvaluationAccessor resAcc) {
        ContainerValue cont = cnt.getValue();
        EvaluationAccessor contAcc = cnt.getAccessor();
        int i = 0;
        while (i < cont.getElementSize()) {
            result.add(cont.getElement(i));
            resAcc.addBoundContainerElement(contAcc, i);
            ++i;
        }
    }

    static final EvaluationAccessor found(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean negate) {
        ConstantAccessor result = null;
        if (1 == arguments.length) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (oValue instanceof ContainerValue) {
                ContainerValue cValue = (ContainerValue)oValue;
                boolean bResult = negate ? cValue.indexOf(aValue) < 0 : cValue.indexOf(aValue) >= 0;
                result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(bResult), true, operand.getContext());
            }
        }
        return result;
    }

    static void flatten(Value value, Collection<Value> result) {
        if (value instanceof ContainerValue) {
            ContainerValue cont = (ContainerValue)value;
            int i = 0;
            int size = cont.getElementSize();
            while (i < size) {
                ContainerOperations.flatten(cont.getElement(i), result);
                ++i;
            }
        } else {
            result.add(value);
        }
    }

    private static class CalcEvaluator
    implements IOperationEvaluator {
        private boolean mult;

        CalcEvaluator(boolean mult) {
            this.mult = mult;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value opValue = operand.getValue();
            if (opValue instanceof ContainerValue) {
                ContainerValue cont = (ContainerValue)opValue;
                boolean isInt = TypeQueries.sameTypes(IntegerType.TYPE, cont.getContainedType());
                boolean isReal = TypeQueries.sameTypes(RealType.TYPE, cont.getContainedType());
                if (isInt || isReal) {
                    int size = cont.getElementSize();
                    try {
                        Value rValue;
                        if (isInt) {
                            int res = this.mult ? 1 : 0;
                            int i = 0;
                            while (i < size) {
                                Value elt = cont.getElement(i);
                                int tmp = ((IntValue)elt).getValue();
                                res = this.mult ? (res *= tmp) : (res += tmp);
                                ++i;
                            }
                            rValue = ValueFactory.createValue(IntegerType.TYPE, res);
                        } else {
                            double res = this.mult ? 1 : 0;
                            int i = 0;
                            while (i < size) {
                                Value elt = cont.getElement(i);
                                double tmp = ((RealValue)elt).getValue();
                                res = this.mult ? (res *= tmp) : (res += tmp);
                                ++i;
                            }
                            rValue = ValueFactory.createValue(RealType.TYPE, res);
                        }
                        result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                    }
                }
            }
            return result;
        }
    }

    static interface Container2Operation {
        public void evaluate(ContainerArgument var1, ContainerArgument var2, List<Value> var3, EvaluationAccessor var4);
    }

    static class Container2OperationEvaluator
    implements IOperationEvaluator {
        private Container2Operation op;

        protected Container2OperationEvaluator(Container2Operation op) {
            this.op = op;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value opValue = operand.getValue();
                Value argValue = arguments[0].getValue();
                if (opValue instanceof ContainerValue && argValue instanceof ContainerValue) {
                    ArrayList<Value> tmp = new ArrayList<Value>();
                    result = (ConstantAccessor)ConstantAccessor.POOL.getInstance();
                    ContainerArgument c1 = ((ContainerArgument)CA_POOL.getInstance()).setValues((ContainerValue)opValue, operand);
                    ContainerArgument c2 = ((ContainerArgument)CA_POOL.getInstance()).setValues((ContainerValue)argValue, arguments[0]);
                    this.op.evaluate(c1, c2, tmp, result);
                    try {
                        Value rValue = ValueFactory.createValue(opValue.getType(), tmp.toArray());
                        result.bind(rValue, false, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                        result = EvaluationAccessor.release(result);
                    }
                    CA_POOL.releaseInstance((Object)c1);
                    CA_POOL.releaseInstance((Object)c2);
                }
            }
            return result;
        }
    }

    static final class ContainerArgument {
        private ContainerValue value;
        private EvaluationAccessor accessor;

        private ContainerArgument() {
        }

        ContainerArgument setValues(ContainerValue value, EvaluationAccessor accessor) {
            this.value = value;
            this.accessor = accessor;
            return this;
        }

        ContainerValue getValue() {
            return this.value;
        }

        EvaluationAccessor getAccessor() {
            return this.accessor;
        }

        private void clear() {
            this.value = null;
            this.accessor = null;
        }
    }

    static interface ContainerValueOperation {
        public void evaluate(ContainerArgument var1, Value var2, List<Value> var3, EvaluationAccessor var4);
    }

    static class ContainerValueOperationEvaluator
    implements IOperationEvaluator {
        private ContainerValueOperation op;

        protected ContainerValueOperationEvaluator(ContainerValueOperation op) {
            this.op = op;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value opValue = operand.getValue();
                Value argValue = arguments[0].getValue();
                if (opValue instanceof ContainerValue && argValue != null) {
                    result = (ConstantAccessor)ConstantAccessor.POOL.getInstance();
                    ContainerArgument ca = ((ContainerArgument)CA_POOL.getInstance()).setValues((ContainerValue)opValue, operand);
                    ArrayList<Value> tmp = new ArrayList<Value>();
                    this.op.evaluate(ca, argValue, tmp, result);
                    try {
                        Value rValue = ValueFactory.createValue(opValue.getType(), tmp.toArray());
                        result.bind(rValue, false, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                        result = EvaluationAccessor.release(result);
                    }
                    CA_POOL.releaseInstance((Object)ca);
                }
            }
            return result;
        }
    }

    static final class FindOperationEvaluator
    implements IOperationEvaluator {
        private boolean negate;

        public FindOperationEvaluator(boolean negate) {
            this.negate = negate;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value oValue = operand.getValue();
                Value aValue = arguments[0].getValue();
                if (oValue instanceof ContainerValue && aValue != null) {
                    boolean bResult;
                    ContainerValue cValue = (ContainerValue)oValue;
                    boolean bl = bResult = cValue.indexOf(aValue) >= 0;
                    if (this.negate) {
                        bResult = !bResult;
                    }
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(bResult), true, operand.getContext());
                }
            }
            return result;
        }
    }

    static final class FlattenOperationEvaluator
    implements IOperationEvaluator {
        private boolean allowDuplicates;

        FlattenOperationEvaluator(boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value oValue = operand.getValue();
            if (oValue instanceof ContainerValue) {
                ContainerValue cont = (ContainerValue)oValue;
                AbstractCollection tmp = this.allowDuplicates ? new ArrayList() : new HashSet();
                int i = 0;
                int size = cont.getElementSize();
                while (i < size) {
                    ContainerOperations.flatten(cont.getElement(i), tmp);
                    ++i;
                }
                IDatatype containerType = cont.getType();
                IDatatype deepest = TypeQueries.findDeepestGeneric(containerType, 0);
                Container resultType = Set.TYPE.isAssignableFrom(containerType) ? new Set("", deepest, null) : new Sequence("", deepest, null);
                try {
                    Value rValue = ValueFactory.createValue(resultType, tmp.toArray());
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rValue, false, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    static final class IncludesAllOperationEvaluator
    implements IOperationEvaluator {
        private boolean exclude;

        public IncludesAllOperationEvaluator(boolean exclude) {
            this.exclude = exclude;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value oValue = operand.getValue();
                Value aValue = arguments[0].getValue();
                if (oValue instanceof ContainerValue && aValue instanceof ContainerValue) {
                    ContainerValue coValue = (ContainerValue)oValue;
                    ContainerValue caValue = (ContainerValue)aValue;
                    boolean all = true;
                    int i = 0;
                    while (all && i < caValue.getElementSize()) {
                        Value val = caValue.getElement(i);
                        all = this.exclude ? (all &= coValue.indexOf(val) < 0) : (all &= coValue.indexOf(val) >= 0);
                        ++i;
                    }
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(all), true, operand.getContext());
                }
            }
            return result;
        }
    }

    static final class IsEmptyOperationEvaluator
    implements IOperationEvaluator {
        private boolean negate;

        public IsEmptyOperationEvaluator(boolean negate) {
            this.negate = negate;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value oValue = operand.getValue();
            if (oValue instanceof ContainerValue) {
                boolean bResult;
                ContainerValue cValue = (ContainerValue)oValue;
                boolean bl = bResult = cValue.getElementSize() == 0;
                if (this.negate) {
                    bResult = !bResult;
                }
                result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(bResult), true, operand.getContext());
            }
            return result;
        }
    }

    static class TypeSelectEvaluator
    implements IOperationEvaluator {
        private boolean reject;
        private boolean kindOf;

        TypeSelectEvaluator(boolean reject, boolean kindOf) {
            this.reject = reject;
            this.kindOf = kindOf;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value opValue = operand.getValue();
                Value argValue = arguments[0].getValue();
                IDecisionVariable opVar = operand.getVariable();
                if (opValue instanceof ContainerValue && argValue instanceof MetaTypeValue) {
                    ContainerValue cont = (ContainerValue)opValue;
                    IDatatype type = ((MetaTypeValue)argValue).getValue();
                    ArrayList<Value> tmp = new ArrayList<Value>();
                    int size = cont.getElementSize();
                    result = (ConstantAccessor)ConstantAccessor.POOL.getInstance();
                    int i = 0;
                    while (i < size) {
                        Value elt = cont.getElement(i);
                        boolean condition = this.kindOf ? type.isAssignableFrom(elt.getType()) : TypeQueries.sameTypes(type, elt.getType());
                        if (this.reject) {
                            boolean bl = condition = !condition;
                        }
                        if (condition) {
                            tmp.add(elt);
                            if (opVar != null) {
                                result.addBoundContainerElement(opVar.getNestedElement(i));
                            }
                        }
                        ++i;
                    }
                    try {
                        Value rValue = ValueFactory.createValue(operand.getValue().getType(), tmp.toArray());
                        result.bind(rValue, false, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        operand.getContext().addErrorMessage(e);
                        result = EvaluationAccessor.release(result);
                    }
                }
            }
            return result;
        }
    }
}

