/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class Operation {
    private static List<Operation> allOperations = new ArrayList<Operation>();
    private static transient Map<Operation, Operation> alias = new HashMap<Operation, Operation>();
    private IDatatype returns;
    private String name;
    private IDatatype[] parameters;
    private IDatatype operand;
    private ReturnTypeMode returnTypeMode = ReturnTypeMode.UNCHANGED;
    private boolean requiresAssignableParameter = false;
    private boolean acceptsNull = false;
    private FormattingHint formattingHint = FormattingHint.FUNCTION_CALL;
    private NestingMode nestingMode = NestingMode.NONE;
    private boolean fallback = false;

    Operation() {
    }

    Operation(IDatatype returns, String name, IDatatype operand, IDatatype ... parameters) {
        this(returns, ReturnTypeMode.UNCHANGED, name, operand, parameters);
    }

    Operation(IDatatype returns, ReturnTypeMode returnTypeMode, String name, IDatatype operand, IDatatype ... parameters) {
        this.returns = returns;
        this.returnTypeMode = returnTypeMode;
        this.name = name;
        this.parameters = parameters;
        this.operand = operand;
        if (this.registerAsOperation()) {
            allOperations.add(this);
        }
    }

    public static Operation createInfixOperator(IDatatype returns, String name, IDatatype operand, IDatatype ... parameters) {
        return new Operation(returns, name, operand, parameters).markByFormattingHint(FormattingHint.OPERATOR_INFIX);
    }

    public static Operation createPrefixOperator(IDatatype returns, String name, IDatatype operand, IDatatype ... parameters) {
        return new Operation(returns, name, operand, parameters).markByFormattingHint(FormattingHint.OPERATOR_PREFIX);
    }

    public static Operation createPostfixOperator(IDatatype returns, String name, IDatatype operand, IDatatype ... parameters) {
        return new Operation(returns, name, operand, parameters).markByFormattingHint(FormattingHint.OPERATOR_POSTFIX);
    }

    public IDatatype getReturns() {
        return this.returns;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    public int getRequiredParameterCount() {
        return this.getParameterCount();
    }

    public IDatatype getParameterType(int index) {
        if (this.parameters == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    public DecisionVariableDeclaration getParameterDeclaration(int index) {
        if (index < 0 || index >= this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    public ConstraintSyntaxTree getParameterDefaultValue(int index) {
        ConstraintSyntaxTree result = null;
        DecisionVariableDeclaration decl = this.getParameterDeclaration(index);
        if (decl != null) {
            result = decl.getDefaultValue();
        }
        return result;
    }

    public DecisionVariableDeclaration getParameter(String name) {
        return null;
    }

    public IDatatype getOperand() {
        return this.operand;
    }

    public ConstraintSyntaxTree getFunction() {
        return null;
    }

    public ReturnTypeMode getReturnTypeMode() {
        return this.returnTypeMode;
    }

    public final IDatatype getActualReturnType(IDatatype immediateOperand, IDatatype ... parameter) {
        ReturnTypeMode mode = this.getReturnTypeMode();
        IDatatype result = switch (mode) {
            case ReturnTypeMode.UNCHANGED -> this.getReturns();
            case ReturnTypeMode.TYPED_OPERAND_1 -> {
                if (Set.TYPE.isAssignableFrom(immediateOperand) && Sequence.TYPE.isAssignableFrom(this.getReturns())) {
                    Set set = (Set)immediateOperand;
                    yield this.createCollectionReturnType(Sequence.TYPE, set.getContainedType(), set.getParent());
                }
                if (Sequence.TYPE.isAssignableFrom(immediateOperand) && Set.TYPE.isAssignableFrom(this.getReturns())) {
                    Sequence sequence = (Sequence)immediateOperand;
                    yield this.createCollectionReturnType(Set.TYPE, sequence.getContainedType(), sequence.getParent());
                }
                yield immediateOperand;
            }
            case ReturnTypeMode.GENERIC_PARAM_1 -> {
                int index = mode.getGenericTypeIndex();
                if (index >= 0 && index < immediateOperand.getGenericTypeCount()) {
                    yield immediateOperand.getGenericType(mode.getGenericTypeIndex());
                }
                yield immediateOperand;
            }
            case ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION -> this.immediateOperandCollection(immediateOperand);
            case ReturnTypeMode.IMMEDIATE_OPERAND -> immediateOperand;
            case ReturnTypeMode.IMMEDIATE_OPERAND_DEREF -> Reference.dereference(immediateOperand);
            case ReturnTypeMode.TYPED_PARAM_1, ReturnTypeMode.PARAM_1_CHECK, ReturnTypeMode.PARAM_1 -> {
                int index = mode.getParameterIndex();
                if (parameter != null && index >= 0 && index < parameter.length) {
                    yield parameter[index];
                }
                yield immediateOperand;
            }
            case ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_PARAM_1 -> this.immediateOperandCollection(mode, immediateOperand, parameter);
            case ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_NESTED_GENERIC_1 -> this.immediateOperandCollection(mode, immediateOperand, TypeQueries.toGenerics(immediateOperand));
            default -> immediateOperand;
        };
        if (NestingMode.NESTING == this.getNestingMode() && Container.TYPE.isAssignableFrom(immediateOperand) && 1 == immediateOperand.getGenericTypeCount() && Container.TYPE.isAssignableFrom(immediateOperand.getGenericType(0))) {
            if (Set.TYPE.isAssignableFrom(result)) {
                result = this.createCollectionReturnType(Set.TYPE, result, null);
            } else if (Sequence.TYPE.isAssignableFrom(result)) {
                result = this.createCollectionReturnType(Sequence.TYPE, result, null);
            }
        }
        return result;
    }

    private IDatatype immediateOperandCollection(IDatatype immediateOperand) {
        IDatatype result = Sequence.TYPE.isAssignableFrom(this.getReturns()) ? this.createCollectionReturnType(Sequence.TYPE, immediateOperand, null) : (Set.TYPE.isAssignableFrom(this.getReturns()) ? this.createCollectionReturnType(Set.TYPE, immediateOperand, null) : immediateOperand);
        return result;
    }

    protected IDatatype createCollectionReturnType(IDatatype aim, IDatatype elementType, IModelElement parent) {
        Container result = null;
        if (Sequence.TYPE == aim) {
            result = new Sequence("", elementType, parent);
        } else if (Set.TYPE == aim) {
            result = new Set("", elementType, parent);
        }
        return result;
    }

    private IDatatype immediateOperandCollection(ReturnTypeMode mode, IDatatype immediateOperand, IDatatype[] parameter) {
        IDatatype result;
        int index = mode.getParameterIndex();
        if (parameter != null && index >= 0 && index < parameter.length) {
            if (Set.TYPE.isAssignableFrom(immediateOperand)) {
                Set set = (Set)immediateOperand;
                IDatatype eltType = mode.recurse() ? TypeQueries.findDeepestGeneric(set, 0) : parameter[index];
                result = this.createCollectionReturnType(Set.TYPE, eltType, set.getParent());
            } else if (Sequence.TYPE.isAssignableFrom(immediateOperand)) {
                Sequence sequence = (Sequence)immediateOperand;
                IDatatype eltType = mode.recurse() ? TypeQueries.findDeepestGeneric(sequence, 0) : parameter[index];
                result = this.createCollectionReturnType(Sequence.TYPE, eltType, sequence.getParent());
            } else {
                result = parameter[index];
            }
        } else {
            result = immediateOperand;
        }
        return result;
    }

    public boolean isContainerOperation() {
        return this.nestingMode != NestingMode.NONE;
    }

    public NestingMode getNestingMode() {
        return this.nestingMode;
    }

    public boolean acceptsNull() {
        return this.acceptsNull;
    }

    Operation markAsFlatteningContainerOperation() {
        this.nestingMode = NestingMode.FLATTEN;
        return this;
    }

    Operation markAsNestingContainerOperation() {
        this.nestingMode = NestingMode.NESTING;
        return this;
    }

    Operation markAsFallback() {
        this.fallback = true;
        return this;
    }

    Operation markAsContainerOperation() {
        this.nestingMode = NestingMode.LEGACY;
        return this;
    }

    Operation markAsAliasOf(Operation op) {
        alias.put(this, op);
        return this;
    }

    Operation markAsAssignableParameterOperation() {
        this.requiresAssignableParameter = true;
        return this;
    }

    Operation markAsAcceptsNull() {
        this.acceptsNull = true;
        return this;
    }

    public boolean requiresAssignableParameter() {
        return this.requiresAssignableParameter;
    }

    Operation markByFormattingHint(FormattingHint formattingHint) {
        if (formattingHint != null) {
            this.formattingHint = formattingHint;
        }
        return this;
    }

    public FormattingHint getFormattingHint() {
        FormattingHint result = this.formattingHint;
        if ((this.formattingHint == FormattingHint.OPERATOR_PREFIX || this.formattingHint == FormattingHint.OPERATOR_POSTFIX) && this.parameters != null && this.parameters.length > 0) {
            result = FormattingHint.FUNCTION_CALL;
        }
        return result;
    }

    public static int getOperationsCount() {
        return allOperations.size();
    }

    public static Operation getOperation(int index) {
        return allOperations.get(index);
    }

    protected boolean registerAsOperation() {
        return true;
    }

    public String getSignature() {
        StringBuilder tmp = new StringBuilder();
        String operand = IvmlDatatypeVisitor.getQualifiedType(this.getOperand());
        if (operand.isEmpty()) {
            IDatatype oType = this.getOperand();
            operand = oType.getName();
        }
        tmp.append(operand);
        tmp.append(".");
        tmp.append(this.getName());
        tmp.append("(");
        int p = 0;
        while (p < this.getParameterCount()) {
            if (p > 0) {
                tmp.append(", ");
            }
            tmp.append(IvmlDatatypeVisitor.getQualifiedType(this.getParameterType(p).getType()));
            ++p;
        }
        tmp.append(")");
        return tmp.toString();
    }

    public static Operation getAlias(Operation op) {
        return op == null ? null : alias.get(op);
    }

    public static enum FormattingHint {
        FUNCTION_CALL,
        OPERATOR_INFIX,
        OPERATOR_PREFIX,
        OPERATOR_POSTFIX;

    }

    public static enum NestingMode {
        NONE,
        LEGACY,
        FLATTEN,
        NESTING;

    }

    public static enum ReturnTypeMode {
        UNCHANGED(-1, -1, false, false),
        IMMEDIATE_OPERAND(-1, -1, false, false),
        IMMEDIATE_OPERAND_DEREF(-1, -1, false, false),
        TYPED_OPERAND_1(0, -1, false, false),
        TYPED_PARAM_1(-1, 0, false, false),
        TYPED_META_1(-1, 0, false, false),
        PARAM_1_CHECK(-1, 0, false, true),
        PARAM_1(-1, 0, false, false),
        GENERIC_PARAM_1(0, -1, false, false),
        IMMEDIATE_OPERAND_COLLECTION_PARAM_1(-1, 0, false, false),
        IMMEDIATE_OPERAND_COLLECTION_NESTED_GENERIC_1(-1, 0, true, false),
        IMMEDIATE_OPERAND_COLLECTION(-1, -1, false, false);

        private int typeIndex;
        private int paramIndex;
        private boolean recurse;
        private boolean checkOperand;

        private ReturnTypeMode(int typeIndex, int paramIndex, boolean recurse, boolean checkOperand) {
            this.typeIndex = typeIndex;
            this.paramIndex = paramIndex;
            this.recurse = recurse;
            this.checkOperand = checkOperand;
        }

        public boolean checkOperand() {
            return this.checkOperand;
        }

        public int getGenericTypeIndex() {
            return this.typeIndex;
        }

        public int getParameterIndex() {
            return this.paramIndex;
        }

        public boolean recurse() {
            return this.recurse;
        }
    }
}

