/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.cst.AbstractConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.ValueCopy;
import net.ssehub.easy.varModel.model.values.Value;

class AssignmentReducer
extends AbstractConstraintTreeVisitor {
    private RewriteContext context;
    private ConstraintSyntaxTree result;
    private boolean filtered;

    AssignmentReducer(RewriteContext context) {
        this.context = context;
        this.result = null;
        this.filtered = false;
    }

    protected ConstraintSyntaxTree reduce(OCLFeatureCall assignment) {
        this.result = assignment;
        if ("=".equals(assignment.getOperation())) {
            this.result = null;
            assignment.getParameter(0).accept(this);
            if (this.filtered && this.result != null) {
                this.result = new OCLFeatureCall(assignment.getOperand(), assignment.getOperation(), this.result);
                try {
                    this.result.inferDatatype();
                }
                catch (CSTSemanticException e) {
                    this.result = null;
                    Bundle.getLogger(AssignmentReducer.class).exception((Exception)e);
                }
            } else if (!this.filtered) {
                this.result = assignment;
            }
        }
        return this.result;
    }

    boolean hasFiltered() {
        return this.filtered;
    }

    @Override
    public void visitConstantValue(ConstantValue constValue) {
        ValueCopy copy = new ValueCopy(this.context, constValue.getConstantValue());
        if (copy.valuesOmitted()) {
            this.filtered = true;
            Value filteredValue = copy.getValue();
            this.result = filteredValue != null ? new ConstantValue(filteredValue) : null;
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        ArrayList<String> slots = new ArrayList<String>();
        ArrayList<AbstractVariable> decls = new ArrayList<AbstractVariable>();
        ArrayList<ConstraintSyntaxTree> csts = new ArrayList<ConstraintSyntaxTree>();
        boolean currentlyFiltered = this.filtered;
        int i = 0;
        int end = initializer.getSlotCount();
        while (i < end) {
            AbstractVariable decl = initializer.getSlotDeclaration(i);
            if (!this.context.elementWasRemoved(decl)) {
                this.filtered = false;
                ConstraintSyntaxTree cst = initializer.getExpression(i);
                cst.accept(this);
                if (this.filtered) {
                    cst = this.result;
                }
                if (cst != null) {
                    slots.add(initializer.getSlot(i));
                    decls.add(decl);
                    csts.add(cst);
                }
            }
            ++i;
        }
        this.filtered = currentlyFiltered;
        if (!slots.isEmpty()) {
            if (slots.size() < initializer.getSlotCount()) {
                try {
                    this.filtered = true;
                    this.result = new CompoundInitializer(initializer.getType(), slots.toArray(new String[0]), decls.toArray(new AbstractVariable[0]), csts.toArray(new ConstraintSyntaxTree[0]));
                }
                catch (CSTSemanticException e) {
                    Bundle.getLogger(AssignmentReducer.class).exception((Exception)e);
                }
            } else {
                this.result = initializer;
            }
        } else {
            this.result = null;
            this.filtered = true;
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        ArrayList<ConstraintSyntaxTree> csts = new ArrayList<ConstraintSyntaxTree>();
        boolean currentlyFiltered = this.filtered;
        int i = 0;
        while (i < initializer.getExpressionCount()) {
            this.filtered = false;
            ConstraintSyntaxTree cst = initializer.getExpression(i);
            cst.accept(this);
            if (this.filtered) {
                cst = this.result;
            }
            if (cst != null) {
                csts.add(cst);
            }
            ++i;
        }
        this.filtered = currentlyFiltered;
        if (!csts.isEmpty()) {
            if (csts.size() < initializer.getExpressionCount()) {
                try {
                    this.filtered = true;
                    this.result = new ContainerInitializer(initializer.getType(), csts.toArray(new ConstraintSyntaxTree[0]));
                }
                catch (CSTSemanticException e) {
                    Bundle.getLogger(AssignmentReducer.class).exception((Exception)e);
                }
            } else {
                this.result = initializer;
            }
        } else {
            this.result = null;
            this.filtered = true;
        }
    }
}

