/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.StructuredValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class CompoundValue
extends StructuredValue
implements Cloneable {
    public static final String SPECIAL_SLOT_NAME_TYPE = ".";
    private HashMap<String, Value> nestedElements;

    CompoundValue() {
    }

    CompoundValue(Compound compound) throws ValueDoesNotMatchTypeException {
        this(compound, (Object[])null);
    }

    CompoundValue(Compound compound, Object ... value) throws ValueDoesNotMatchTypeException {
        super(compound);
        this.nestedElements = new HashMap();
        if (value != null && value.length % 2 != 0) {
            throw new ValueDoesNotMatchTypeException("amount of slot names and values does not match for type " + compound.getType().getName(), 10202);
        }
        HashMap<String, Object> initialValues = new HashMap<String, Object>();
        if (value != null) {
            int v = 0;
            while (v < value.length) {
                String slotName = value[v].toString();
                if (!slotName.equals(SPECIAL_SLOT_NAME_TYPE)) {
                    initialValues.put(slotName, value[v + 1]);
                }
                v += 2;
            }
        }
        this.initialize(compound, initialValues);
        int a = 0;
        while (a < compound.getAssignmentCount()) {
            this.initializeAttributeAssignment(compound.getAssignment(a), initialValues);
            ++a;
        }
    }

    protected CompoundValue(Compound compound, CompoundValue source) {
        super(compound);
        this.nestedElements = new HashMap();
        try {
            this.copyValuesFrom(source);
        }
        catch (ValueDoesNotMatchTypeException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeAttributeAssignment(AttributeAssignment assng, Map<String, Object> initialValues) throws ValueDoesNotMatchTypeException {
        this.initialize(assng, initialValues);
        int a = 0;
        while (a < assng.getAssignmentCount()) {
            this.initializeAttributeAssignment(assng.getAssignment(a), initialValues);
            ++a;
        }
    }

    private void initialize(IDecisionVariableContainer container, Map<String, Object> initialValues) throws ValueDoesNotMatchTypeException {
        boolean isCompound = container instanceof Compound;
        Compound cmpContainer = null;
        if (isCompound) {
            cmpContainer = (Compound)container;
        }
        int elementCount = isCompound ? cmpContainer.getInheritedElementCount() : container.getElementCount();
        int i = 0;
        while (i < elementCount) {
            block15: {
                Object[] slotVals;
                DecisionVariableDeclaration decl = isCompound ? cmpContainer.getInheritedElement(i) : container.getElement(i);
                IDatatype type = decl.getType();
                String name = decl.getName();
                Object oVal = initialValues.get(name);
                boolean done = false;
                if (oVal == null) {
                    slotVals = new Object[1];
                    slotVals = null;
                } else if (oVal.getClass().isArray()) {
                    slotVals = (Object[])oVal;
                } else if (oVal instanceof ConstraintSyntaxTree) {
                    this.configureValue(name, oVal);
                    slotVals = null;
                    done = true;
                } else if (oVal instanceof Value) {
                    this.configureValue(name, oVal);
                    slotVals = null;
                    done = true;
                } else {
                    slotVals = new Object[]{oVal};
                }
                if (!done) {
                    try {
                        if (slotVals != null) {
                            this.nestedElements.put(name, ValueFactory.createValue(type, slotVals));
                        } else {
                            this.nestedElements.put(name, null);
                        }
                    }
                    catch (ValueDoesNotMatchTypeException vdnmte) {
                        if (slotVals == null) break block15;
                        throw vdnmte;
                    }
                }
            }
            ++i;
        }
    }

    public static final IDatatype getActualType(Object[] slotValues) {
        IDatatype result = null;
        if (slotValues != null && slotValues.length % 2 == 0) {
            int s = 0;
            while (s < slotValues.length) {
                if (slotValues[s].toString().equals(SPECIAL_SLOT_NAME_TYPE) && slotValues[s + 1] instanceof IDatatype) {
                    result = (IDatatype)slotValues[s + 1];
                }
                s += 2;
            }
        }
        return result;
    }

    public Value getNestedValue(String name) {
        return this.nestedElements.get(name);
    }

    @Override
    public Object getValue() {
        int size = 2 + (this.nestedElements != null ? 2 * this.nestedElements.size() : 0);
        Object[] result = new Object[size];
        int pos = 0;
        result[pos++] = SPECIAL_SLOT_NAME_TYPE;
        result[pos++] = this.getType();
        for (Map.Entry<String, Value> ent : this.nestedElements.entrySet()) {
            result[pos++] = ent.getKey();
            result[pos++] = ent.getValue();
        }
        return result;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitCompoundValue(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configureValue(String name, Object value) throws ValueDoesNotMatchTypeException {
        if (value != null) {
            Value newValue;
            DecisionVariableDeclaration field = ((Compound)this.getType()).getElement(name);
            if (field == null) throw new ValueDoesNotMatchTypeException("field " + name + " does not exist", 10202);
            if (value instanceof Value) {
                newValue = (Value)value;
                if (!field.getType().isAssignableFrom(newValue.getType())) {
                    throw new ValueDoesNotMatchTypeException("value '" + String.valueOf(newValue.getValue()) + "' of type '" + IvmlDatatypeVisitor.getUnqualifiedType(newValue.getType()) + "' cannot be assigned to field '" + field.getName() + "' of type '" + IvmlDatatypeVisitor.getUnqualifiedType(field.getType()) + "'", 10203);
                }
                Value oldValue = this.getNestedValue(name);
                if (oldValue != null && oldValue instanceof CompoundValue && newValue instanceof CompoundValue) {
                    ((CompoundValue)oldValue).copyValuesFrom((CompoundValue)newValue);
                    newValue = oldValue;
                }
            } else {
                newValue = value.getClass().isArray() ? ValueFactory.createValue(field.getType(), (Object[])value) : ValueFactory.createValue(field.getType(), value);
            }
            this.nestedElements.put(name, newValue);
            return;
        } else {
            this.nestedElements.put(name, null);
        }
    }

    public void copyValuesFrom(CompoundValue source) throws ValueDoesNotMatchTypeException {
        Compound sourceType = (Compound)source.getType();
        Compound myType = (Compound)this.getType();
        if (myType.isAssignableFrom(sourceType)) {
            int i = 0;
            while (i < myType.getInheritedElementCount()) {
                DecisionVariableDeclaration decl = myType.getInheritedElement(i);
                String name = decl.getName();
                Value oldValue = this.nestedElements.get(name);
                Value newValue = source.getNestedValue(name);
                if (oldValue == null || newValue != null) {
                    this.nestedElements.put(name, source.getNestedValue(name));
                }
                ++i;
            }
        } else {
            throw new ValueDoesNotMatchTypeException("compound '" + sourceType.getName() + "' cannot be assigned to '" + myType.getName() + "'", this, 10203);
        }
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (value instanceof CompoundValue) {
            this.copyValuesFrom((CompoundValue)value);
        } else if (value == null) {
            this.nestedElements.clear();
        } else if (value != null) {
            throw new ValueDoesNotMatchTypeException("<not implemented>", this, 10204);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        boolean fullyConfigured = true;
        Iterator<Value> valueIterator = this.nestedElements.values().iterator();
        while (valueIterator.hasNext() && fullyConfigured) {
            Value nestedValue = valueIterator.next();
            boolean bl = fullyConfigured = nestedValue != null && nestedValue.isConfigured();
        }
        return fullyConfigured;
    }

    @Override
    public CompoundValue clone() {
        CompoundValue clonedValue = null;
        clonedValue = (CompoundValue)super.clone();
        clonedValue.nestedElements = new HashMap();
        for (Map.Entry<String, Value> item : this.nestedElements.entrySet()) {
            String slotname = item.getKey();
            Value clonedNestedValue = null;
            if (item.getValue() != null) {
                clonedNestedValue = item.getValue().clone();
            }
            clonedValue.nestedElements.put(slotname, clonedNestedValue);
        }
        return clonedValue;
    }

    @Override
    public String toString() {
        return this.nestedElements.toString();
    }

    @Override
    public int hashCode() {
        return this.getType().getName().hashCode() + this.hashCode((Compound)this.getType());
    }

    private int hashCode(Compound type) {
        int result = 0;
        int s = 0;
        while (s < type.getElementCount()) {
            String slotName = type.getElement(s).getName();
            Value myValue = this.getNestedValue(slotName);
            if (myValue != null) {
                result += myValue.hashCode();
            }
            ++s;
        }
        int r = 0;
        while (r < type.getRefinesCount()) {
            result += this.hashCode(type.getRefines(r));
            ++r;
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    private boolean equals(Object object, boolean ignoreUndefinedInObject) {
        CompoundValue oCompound;
        IDatatype oType;
        boolean equals = false;
        Compound type = (Compound)this.getType();
        if (object instanceof CompoundValue && type.isAssignableFrom(oType = (oCompound = (CompoundValue)object).getType()) && oType.isAssignableFrom(type)) {
            CompoundValue otherValue = (CompoundValue)object;
            equals = this.equals(type, otherValue, ignoreUndefinedInObject);
        }
        return equals;
    }

    private boolean equals(Compound type, CompoundValue otherValue, boolean ignoreUndefinedInObject) {
        boolean equals = this.checkElements(type, otherValue, ignoreUndefinedInObject) && this.checkAssignments(type, otherValue, ignoreUndefinedInObject);
        int r = 0;
        while (equals && r < type.getRefinesCount()) {
            equals = this.equals(type.getRefines(r), otherValue, ignoreUndefinedInObject);
            ++r;
        }
        return equals;
    }

    private boolean checkAssignments(IDecisionVariableContainer container, CompoundValue otherValue, boolean ignoreUndefinedInObject) {
        boolean equals = true;
        int a = 0;
        while (equals && a < container.getAssignmentCount()) {
            AttributeAssignment assng = container.getAssignment(a);
            equals = this.checkElements(assng, otherValue, ignoreUndefinedInObject) && this.checkAssignments(assng, otherValue, ignoreUndefinedInObject);
            ++a;
        }
        return equals;
    }

    private boolean checkElements(IDecisionVariableContainer container, CompoundValue otherValue, boolean ignoreUndefinedInObject) {
        boolean equals = true;
        int s = 0;
        while (equals && s < container.getElementCount()) {
            String slotName = container.getElement(s).getName();
            Value oValue = otherValue.getNestedValue(slotName);
            if (!ignoreUndefinedInObject || ignoreUndefinedInObject && oValue != null) {
                Value myValue = this.getNestedValue(slotName);
                equals = myValue == null ? oValue == null : myValue.equals(oValue);
            }
            ++s;
        }
        return equals;
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value, true);
    }

    public String getStringValue(String slot) {
        String result = null;
        Value nameVal = this.getNestedValue(slot);
        if (nameVal instanceof StringValue) {
            result = ((StringValue)nameVal).getValue();
        }
        return result;
    }

    public Boolean getBooleanValue(String slot) {
        Boolean result = null;
        Value nameVal = this.getNestedValue(slot);
        if (nameVal instanceof BooleanValue) {
            result = ((BooleanValue)nameVal).getValue();
        }
        return result;
    }

    public Collection<String> getSlotNames() {
        return this.nestedElements.keySet();
    }

    public int getNestedElementsSize() {
        return this.nestedElements.size();
    }
}

