/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class EnumValue
extends Value {
    private EnumLiteral literal;

    EnumValue() {
        super(null);
    }

    protected EnumValue(Enum enumType) {
        this(enumType, null);
    }

    protected EnumValue(Enum enumType, EnumLiteral literal) {
        super(enumType);
        this.literal = literal;
    }

    protected EnumValue(Enum enumType, Object value) throws ValueDoesNotMatchTypeException {
        super(enumType);
        if (value == null) {
            throw new ValueDoesNotMatchTypeException("null is not a valid enum literal", 10200);
        }
        if (value instanceof EnumLiteral) {
            EnumLiteral lit = (EnumLiteral)value;
            if (!enumType.has(lit)) {
                throw new ValueDoesNotMatchTypeException(value.toString(), enumType, 10201);
            }
            this.literal = lit;
        } else {
            this.setValue(value);
        }
    }

    @Override
    public EnumLiteral getValue() {
        return this.literal;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitEnumValue(this);
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        String sValue;
        if (value == null) {
            throw new ValueDoesNotMatchTypeException("null is not a valid enum literal", 10200);
        }
        Enum enumType = (Enum)this.getType();
        EnumLiteral lit = enumType.get(sValue = this.stringValueOf(value));
        if (lit == null) {
            throw new ValueDoesNotMatchTypeException(sValue, enumType, 10201);
        }
        this.literal = lit;
    }

    @Override
    public boolean isConfigured() {
        return this.literal != null;
    }

    @Override
    public Value clone() {
        return new EnumValue((Enum)this.getType(), this.literal);
    }

    @Override
    public int hashCode() {
        return this.literal != null ? this.literal.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.literal != null && object instanceof EnumValue) {
            result = this.literal.equals(((EnumValue)object).getValue());
        }
        return result;
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value);
    }
}

