/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.standalone.cmd.InstantiationCommands;
import net.ssehub.easy.standalone.cmd.LowlevelCommands;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;

public final class EASyExec {
    private static final String WS_PATH = "C:/Elscha/Eclipse/runtime-EclipseApplication2";
    private static final File WS_FILE = new File("C:/Elscha/Eclipse/runtime-EclipseApplication2");
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(EASyExec.class, "EASyCommandLine");

    public static void main(String[] args) {
        try {
            LowlevelCommands.startEASy();
        }
        catch (IOException e1) {
            LOGGER.exception((Exception)e1);
            System.exit(1);
        }
        if (null != args && args.length > 1) {
            if ("instantiateSelf".equals(args[0])) {
                EASyExec.instantiateSelf(args);
            } else if ("instantiate".equals(args[0])) {
                EASyExec.instantiate(args);
            }
        } else {
            EASyExec.runDemo();
        }
        System.exit(0);
    }

    private static void instantiateSelf(String[] args) {
        File project = new File(args[1]);
        try {
            switch (args.length) {
                case 2: {
                    InstantiationCommands.instantiateSelf(project);
                    break;
                }
                case 3: {
                    File ivmlFile1 = new File(args[2]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile1);
                    break;
                }
                case 4: {
                    File ivmlFile2 = new File(args[2]);
                    File vilFile = new File(args[3]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile2, vilFile);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            System.exit(2);
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            System.exit(4);
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            System.exit(3);
        }
    }

    private static void instantiate(String[] args) {
        File projectSRC = new File(args[1]);
        File projectTRG = new File(args[2]);
        try {
            switch (args.length) {
                case 3: {
                    InstantiationCommands.instantiate(projectSRC, projectTRG);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            System.exit(4);
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            System.exit(3);
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            System.exit(1);
        }
    }

    private static void runDemo() {
        LOGGER.info("Running static example");
        LowlevelCommands.loadWorkspace(WS_FILE);
        PLPInfo plp = LowlevelCommands.getProject("New_Product");
        if (null != plp) {
            Configuration config = plp.getConfiguration();
            System.out.println("Number of variables: " + config.getDecisionCount());
            for (IDecisionVariable var : config) {
                System.out.println(var.getDeclaration().getName() + " = " + var.getValue());
            }
        }
    }
}

