/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.ant;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.standalone.ant.AbstractEASyTask;
import net.ssehub.easy.standalone.cmd.InstantiationCommands;
import net.ssehub.easy.standalone.cmd.LowlevelCommands;
import net.ssehub.easy.standalone.cmd.ProjectNameMapper;
import net.ssehub.easy.varModel.confModel.Configuration;
import org.apache.tools.ant.BuildException;

public class EASy
extends AbstractEASyTask {
    private String reasoner;

    public void setReasoner(String reasoner) {
        this.reasoner = reasoner;
    }

    public void execute() throws BuildException {
        if (null != this.getProjectName()) {
            ProjectNameMapper.setInstance(new ProjectNameMapper(){

                @Override
                public String getName(File project) {
                    return EASy.this.getProjectName();
                }
            });
        }
        try {
            LowlevelCommands.startEASy();
            if (null != this.reasoner) {
                String[] tmp = this.reasoner.split(":");
                if (null == tmp || 0 == tmp.length) {
                    throw new BuildException("reasoner not given in form name:version");
                }
                ReasonerFrontend frontend = ReasonerFrontend.getInstance();
                IReasoner reasoner = frontend.findReasoner(tmp[0], tmp[1]);
                if (null == reasoner) {
                    throw new BuildException("reasoner not found: " + reasoner);
                }
                frontend.setReasonerHint(reasoner.getDescriptor());
                LowlevelCommands.loadProject(this.getSource());
                String projectName = ProjectNameMapper.getInstance().getName(this.getSource());
                PLPInfo plpPre = LowlevelCommands.getProject(projectName);
                Configuration config = plpPre.getConfiguration();
                ReasonerConfiguration rConfig = new ReasonerConfiguration();
                ReasoningResult result = ReasonerFrontend.getInstance().check(config, rConfig, ProgressObserver.NO_OBSERVER);
                if (result.hasConflict()) {
                    String msg = "";
                    for (int r = 0; r < result.getMessageCount(); ++r) {
                        Message m = result.getMessage(r);
                        msg = msg + m.getStatus() + ":" + m.getDescription();
                    }
                    throw new BuildException(msg);
                }
            }
            InstantiationCommands.instantiate(this.getSource(), this.getTarget());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (VilException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (PersistenceException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }
}

